/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.provider.impl;

import com.elitescloud.boot.common.annotation.BigDecimalFormat;
import com.elitescloud.boot.context.properties.DataFormatterProperties;
import com.elitescloud.boot.provider.DataFormatterProvider;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataFormatterProvider
implements DataFormatterProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataFormatterProvider.class);
    private final DataFormatterProperties properties;

    public DefaultDataFormatterProvider(DataFormatterProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean supportBigDecimal() {
        return this.properties.getBigDecimal() != null && Boolean.TRUE.equals(this.properties.getBigDecimal().getEnabled());
    }

    @Override
    public BigDecimal format(BigDecimal value, BigDecimalFormat format) {
        return this.execute(value, format);
    }

    private BigDecimal execute(BigDecimal value, BigDecimalFormat format) {
        if (!this.supportBigDecimal()) {
            return value;
        }
        logger.debug("\u683c\u5f0f\u5316\u5904\u7406BigDecimal\u6570\u636e\uff1a{}", (Object)value);
        if (format == null) {
            return value;
        }
        DataFormatterProperties.BigDecimalCfg cfg = null;
        switch (format.bdType()) {
            case AMOUNT: {
                cfg = this.properties.getBigDecimal().getAmount();
                break;
            }
            case PRICE: {
                cfg = this.properties.getBigDecimal().getPrice();
                break;
            }
            case QUANTITY: {
                cfg = this.properties.getBigDecimal().getQuantity();
                break;
            }
            case CUSTOM: {
                cfg = new DataFormatterProperties.BigDecimalCfg();
                cfg.setDefaultScale(format.scale());
                cfg.setDefaultRoundingMode(format.roundingMode());
                break;
            }
            default: {
                logger.error("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a{}", (Object)format.bdType());
                return value;
            }
        }
        RoundingMode roundingMode = cfg.getDefaultRoundingMode() == null ? RoundingMode.valueOf(cfg.getDefaultRoundingModeValue()) : cfg.getDefaultRoundingMode();
        BigDecimal formattedValue = value.setScale(cfg.getDefaultScale(), roundingMode);
        logger.debug("\u683c\u5f0f\u5316\u5904\u7406BigDecimal\u6570\u636e\uff1a{}\uff0c{}", (Object)value, (Object)formattedValue);
        return formattedValue;
    }
}

