/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LockUtil {
    private static final Logger log = LoggerFactory.getLogger(LockUtil.class);
    private static final ConcurrentHashMap<String, Lock> LOCAL_LOCK = new ConcurrentHashMap(512);
    private static RedissonClient redissonClient;

    private LockUtil() {
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier) {
        return LockUtil.executeByLock(lockKey, supplier, null);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration) {
        return LockUtil.executeByLock(lockKey, supplier, duration, null);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration, String acquireFailMsg) {
        Assert.hasText((String)lockKey, (String)"\u9501\u7684\u6807\u8bc6\u4e3a\u7a7a");
        if (duration == null) {
            duration = Duration.ofMinutes(10L);
        }
        Lock lockLocal = LOCAL_LOCK.computeIfAbsent(lockKey, c -> new ReentrantLock());
        RLock lockRemote = null;
        try {
            log.info("\u5c1d\u8bd5\u83b7\u53d6\u672c\u5730\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
            if (lockLocal.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                lockRemote = LockUtil.getRedissonClient().getLock(lockKey);
                log.info("\u5c1d\u8bd5\u83b7\u53d6\u8fdc\u7a0b\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
                if (lockRemote.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                    T t = supplier.get();
                    return t;
                }
            }
            try {
                throw new BusinessException(CharSequenceUtil.blankToDefault((CharSequence)acquireFailMsg, (String)("\u672a\u83b7\u53d6\u5230\u9501" + lockKey + "\uff0c\u7b49\u5f85\u8d85\u65f6")));
            }
            catch (Throwable e) {
                log.error("\u52a0\u9501\u7684\u65b9\u6cd5\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                if (e instanceof RuntimeException) {
                    throw (BusinessException)e;
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            log.info("\u91ca\u653e\u672c\u5730\u9501\uff1a{}", (Object)lockKey);
            try {
                lockLocal.unlock();
            }
            catch (Exception e) {
                log.error("\u672c\u5730\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
            }
            if (lockRemote != null && lockRemote.isLocked()) {
                log.info("\u91ca\u653e\u8fdc\u7a0b\u9501\uff1a{}", (Object)lockKey);
                try {
                    lockRemote.unlock();
                }
                catch (Exception e) {
                    log.error("\u8fdc\u7a0b\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                }
            }
        }
    }

    private static RedissonClient getRedissonClient() {
        if (redissonClient == null) {
            redissonClient = SpringContextHolder.getBean(RedissonClient.class);
        }
        return redissonClient;
    }
}

