/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.common.servlet;

import cn.hutool.core.collection.CollUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CloudtRequestAttributes {
    private final RequestAttributes requestAttributes;
    private final Map<String, Object> attributes;

    private CloudtRequestAttributes(RequestAttributes requestAttributes) {
        this.requestAttributes = requestAttributes;
        this.attributes = this.obtainAttributes(requestAttributes);
    }

    public static CloudtRequestAttributes getInstance() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return new CloudtRequestAttributes(requestAttributes);
    }

    public RequestAttributes getRequestAttributes() {
        if (this.requestAttributes == null) {
            return null;
        }
        if (CollUtil.isNotEmpty(this.attributes)) {
            HttpServletRequest request = ((ServletRequestAttributes)this.requestAttributes).getRequest();
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return this.requestAttributes;
    }

    private Map<String, Object> obtainAttributes(RequestAttributes requestAttributes) {
        if (requestAttributes == null) {
            return Collections.emptyMap();
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        HashMap<String, Object> attrMap = new HashMap<String, Object>(16);
        request.getAttributeNames().asIterator().forEachRemaining(attr -> attrMap.put((String)attr, request.getAttribute(attr)));
        return attrMap;
    }
}

