/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.condition.support;

import com.elitescloud.boot.condition.ConditionalOnRpc;
import com.elitescloud.boot.condition.support.AbstractCondition;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class OnRpcCondition
extends AbstractCondition {
    private static final String TRUE = "true";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean enabledDubbo;
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnRpc.class.getName());
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        if (!(enabledDubbo = this.enabledDubbo(context)) && this.existsAttribute(attributes, "requiredDubbo", TRUE)) {
            return ConditionOutcome.noMatch((String)"\u672a\u542f\u7528dubbo");
        }
        boolean enabledOpenFeign = this.enabledOpenFeign(context);
        if (!enabledOpenFeign && this.existsAttribute(attributes, "requiredOpenFeign", TRUE)) {
            return ConditionOutcome.noMatch((String)"\u672a\u542f\u7528OpenFeign");
        }
        if (enabledDubbo || enabledOpenFeign) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch((String)"\u672a\u542f\u7528RPC");
    }

    private boolean enabledDubbo(ConditionContext context) {
        boolean present = this.isPresent("org.apache.dubbo.config.bootstrap.DubboBootstrap", null);
        if (!present) {
            return false;
        }
        String enabled = context.getEnvironment().getProperty("dubbo.enabled");
        return !StringUtils.hasText((String)enabled) || enabled.equalsIgnoreCase(TRUE);
    }

    private boolean enabledOpenFeign(ConditionContext context) {
        return this.isPresent("org.springframework.cloud.openfeign.FeignClient", null);
    }
}

