/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;

public class AspectUtil {
    private AspectUtil() {
    }

    public static Object getTargetBean(@NotNull JoinPoint joinPoint) {
        return joinPoint.getTarget();
    }

    public static Method getTargetMethod(@NotNull JoinPoint joinPoint) {
        MethodSignature methodSignature = AspectUtil.getMethodSignature(joinPoint);
        return methodSignature == null ? null : methodSignature.getMethod();
    }

    public static MethodSignature getMethodSignature(@NotNull JoinPoint joinPoint) {
        if (!(joinPoint instanceof MethodInvocationProceedingJoinPoint)) {
            return null;
        }
        return (MethodSignature)joinPoint.getSignature();
    }

    public static <T extends Annotation> T[] getAnnotations(@NotNull JoinPoint point, @NotNull Class<T> annotationType) {
        Object[] annotation;
        Method method = AspectUtil.getTargetMethod(point);
        if (method != null && ArrayUtil.isNotEmpty((Object[])(annotation = method.getAnnotationsByType(annotationType)))) {
            return annotation;
        }
        Object targetBean = AspectUtil.getTargetBean(point);
        return targetBean == null ? new Annotation[]{} : targetBean.getClass().getAnnotationsByType(annotationType);
    }

    public static <T extends Annotation> T getAnnotation(@NotNull JoinPoint point, @NotNull Class<T> annotationType) {
        Object[] annotations = AspectUtil.getAnnotations((JoinPoint)point, annotationType);
        return (T)(ArrayUtil.isEmpty((Object[])annotations) ? null : annotations[0]);
    }
}

