/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.system.SystemUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CloudtBootUtil {
    private static final Logger logger = LoggerFactory.getLogger(CloudtBootUtil.class);
    private static final Package PACKAGE = CloudtBootUtil.class.getPackage();

    private CloudtBootUtil() {
    }

    public static String getVersion() {
        return PACKAGE.getImplementationVersion();
    }

    public static String getProjectVersion() {
        Class<?> mainClass = SpringContextHolder.getMainClass();
        Assert.notNull(mainClass, (String)"\u670d\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u542f\u52a8\u7c7b");
        String version = mainClass.getPackage().getImplementationVersion();
        if (StringUtils.hasText((String)version)) {
            return version;
        }
        CloudtProjectInfo projectInfo = null;
        try {
            projectInfo = CloudtBootUtil.getBuildInfo();
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u672c\u5730\u6784\u5efa\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return projectInfo == null ? null : projectInfo.getProjectVersion();
    }

    public static String getJavaVersion() {
        Runtime.Version version = Runtime.version();
        if (version != null) {
            return version.toString();
        }
        return SystemUtil.get((String)"java.version", (boolean)false);
    }

    public static CloudtProjectInfo getBuildInfo() {
        URL mainClassUrl = SpringContextHolder.getMainClass().getClassLoader().getResource("");
        if (mainClassUrl == null) {
            return null;
        }
        Object urlPath = mainClassUrl.toString();
        int buildIndex = ((String)urlPath).indexOf("/build/");
        if (buildIndex < 1) {
            return null;
        }
        urlPath = ((String)urlPath).substring(0, buildIndex) + "/build/cloudtProjectInfo.properties";
        Properties properties = new Properties();
        try {
            properties.load(new URL((String)urlPath).openStream());
        }
        catch (Exception e) {
            throw new BusinessException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return new CloudtProjectInfo(properties);
    }

    public static class CloudtProjectInfo {
        private final Properties properties;
        private String projectName;
        private String projectVersion;
        private String projectGroup;
        private String projectDescription;
        private String projectStatus;
        private String projectBuildTime;
        private String userName;
        private String javaVersion;
        private String osName;
        private String osHost;
        private String osHostname;

        public CloudtProjectInfo(Properties properties) {
            this.properties = properties;
        }

        public String getProjectName() {
            return this.properties.getProperty("project.name");
        }

        public String getProjectVersion() {
            return this.properties.getProperty("project.version");
        }

        public String getProjectGroup() {
            return this.properties.getProperty("project.group");
        }

        public String getProjectDescription() {
            return this.properties.getProperty("project.description");
        }

        public String getProjectStatus() {
            return this.properties.getProperty("project.status");
        }

        public String getProjectBuildTime() {
            return this.properties.getProperty("project.buildTime");
        }

        public String getUserName() {
            return this.properties.getProperty("user.name");
        }

        public String getJavaVersion() {
            return this.properties.getProperty("java.version");
        }

        public String getOsName() {
            return this.properties.getProperty("os.name");
        }

        public String getOsHost() {
            return this.properties.getProperty("os.host");
        }

        public String getOsHostname() {
            return this.properties.getProperty("os.hostname");
        }
    }
}

