/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.util.ClassUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.translate.TranslatorCustomizer;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.util.BeanWrapperUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTranslateUtil {
    private static final Logger log = LoggerFactory.getLogger(DataTranslateUtil.class);
    private static List<TranslatorCustomizer> translatorCustomizers = null;
    private static TenantClientProvider tenantClientProvider = null;

    public static void translate(@NotNull Object data) {
        DataTranslateUtil.translate(data, false);
    }

    public static void translate(@NotNull Object data, boolean recursive) {
        DataTranslateUtil.translate(data, recursive, null);
    }

    public static void translate(@NotNull Object data, boolean recursive, Set<String> ignoredTranslators) {
        List<TranslatorCustomizer> translators = DataTranslateUtil.getTranslatorCustomizers();
        if (translators.isEmpty()) {
            return;
        }
        SysTenantDTO tenant = DataTranslateUtil.getTenantClientProvider().getSessionTenant();
        ObjUtil.unwrap(data, obj -> {
            if (!DataTranslateUtil.supportTranslate(obj)) {
                return;
            }
            HashSet<String> executedTranslators = new HashSet<String>(translators.size());
            for (TranslatorCustomizer translator : translators) {
                log.debug("\u5f00\u59cb\u4f7f\u7528{}\u8fdb\u884c\u7ffb\u8bd1...", (Object)translator.code());
                if (ignoredTranslators != null && ignoredTranslators.contains(translator.code()) || executedTranslators.contains(translator.code())) continue;
                executedTranslators.add(translator.code());
                try {
                    DataTranslateUtil.executeTranslate(translator, obj, tenant, recursive);
                }
                catch (Exception e) {
                    log.error("\u7ffb\u8bd1\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)translator.code(), (Object)e);
                }
            }
        });
    }

    private static void executeTranslate(TranslatorCustomizer translator, Object data, SysTenantDTO tenant, boolean recursive) throws Exception {
        translator.translate(data, tenant);
        if (!recursive || !translator.supportRecursive()) {
            return;
        }
        List<BeanWrapperUtil.CustomField> fields = BeanWrapperUtil.getFields(data);
        Object value = null;
        for (BeanWrapperUtil.CustomField field : fields) {
            if (field.getReadMethod() == null || !DataTranslateUtil.supportTranslate(field.getField().getType()) || ObjUtil.isEmpty(value = field.getReadMethod().invoke(data, new Object[0]))) continue;
            DataTranslateUtil.executeTranslate(translator, value, tenant, recursive);
        }
    }

    private static boolean supportTranslate(Object data) {
        if (data instanceof Class) {
            return !ClassUtil.isSimpleValueType((Class)((Class)data));
        }
        return !ObjUtil.isEmpty(data) && !ClassUtil.isSimpleValueType(data.getClass());
    }

    private static List<TranslatorCustomizer> getTranslatorCustomizers() {
        if (translatorCustomizers == null) {
            translatorCustomizers = SpringContextHolder.getObjectProvider(TranslatorCustomizer.class).stream().collect(Collectors.toList());
        }
        return translatorCustomizers;
    }

    private static TenantClientProvider getTenantClientProvider() {
        if (tenantClientProvider == null) {
            tenantClientProvider = SpringContextHolder.getBean(TenantClientProvider.class);
        }
        return tenantClientProvider;
    }
}

