/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class NetUtil {
    private NetUtil() {
    }

    public static String currentIp() {
        InetAddress address = NetUtil.getCurrentServerAddress();
        return address == null ? null : address.getHostAddress();
    }

    private static InetAddress getCurrentServerAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress;
                }
            }
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            throw new IllegalStateException("\u89e3\u6790IP\u5f02\u5e38", e);
        }
    }
}

