/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util.database;

import org.springframework.orm.jpa.vendor.Database;

public class SqlUtil {
    public static String generateSwitchSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL: 
            case SQL_SERVER: {
                return String.format("USE %s", schema);
            }
            case ORACLE: {
                return String.format("ALTER SESSION SET CURRENT_SCHEMA = \"%s\"", schema);
            }
            case POSTGRESQL: {
                return String.format("SET SEARCH_PATH TO '%s'", schema);
            }
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff1a" + databaseType.name());
    }

    public static String generateExistsSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL: {
                return String.format("SELECT * FROM information_schema.schemata WHERE schema_name='%s' LIMIT 1", schema);
            }
            case ORACLE: {
                return String.format("SELECT * FROM ALL_USERS WHERE USERNAME = '%s'", schema);
            }
            case POSTGRESQL: {
                return String.format("SELECT EXISTS(SELECT 1 FROM PG_NAMESPACE WHERE NSPNAME = '%s')", schema);
            }
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff1a" + databaseType.name());
    }

    public static String generateDropSchemaSql(Database databaseType, String schema) {
        switch (databaseType) {
            case MYSQL: {
                return String.format("DROP SCHEMA `%s`", schema);
            }
            case ORACLE: {
                return String.format("DROP USER \"%s\" CASCADE", schema);
            }
            case POSTGRESQL: {
                return String.format("DROP SCHEMA IF EXISTS %s CASCADE", schema);
            }
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u6570\u636e\u5e93\uff1a" + databaseType.name());
    }
}

