/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.security.common;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public enum InnerUserEnum {
    ADMIN(1L, "admin", "\u7cfb\u7edf\u7ba1\u7406\u5458");

    private final Long id;
    private final String username;
    private final String displayName;
    private static final Map<String, InnerUserEnum> USER_MAP;

    private InnerUserEnum(Long id, String username, String displayName) {
        this.id = id;
        this.username = username;
        this.displayName = displayName;
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static InnerUserEnum parse(String username) {
        if (!StringUtils.hasText((String)username)) {
            return null;
        }
        return USER_MAP.get(username);
    }

    static {
        USER_MAP = Arrays.stream(InnerUserEnum.values()).collect(Collectors.toMap(InnerUserEnum::getUsername, t -> t, (t1, t2) -> t1));
    }
}

