/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.vo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class SysUserDTO
implements Serializable {
    private static final long serialVersionUID = -307368107814607072L;
    private Long id;
    private Long tenantId;
    private Long ouId;
    private String ouCode;
    private String ouName;
    private String username;
    private String password;
    private String lastName;
    private String firstName;
    private String mobile;
    private String email;
    private Long casUserId;
    private String wxOpenid;
    private String sourceType;
    private Boolean enabled;
    private Boolean needReset;
    private LocalDateTime expiredTime;
    private LocalDateTime pwdExpiredTime;
    private Boolean locked;
    @Deprecated
    private String userType;
    private Set<String> roleCodes = Collections.emptySet();
    private Set<Long> roleIds = Collections.emptySet();
    private List<IdCodeNameParam> roles = Collections.emptyList();
    private String avatarUrl;
    private String avatarCode;
    @Deprecated
    private List<Terminal> terminals = Collections.emptyList();
    private List<SysTenantDTO> sysTenantDTOList = Collections.emptyList();
    private SysTenantDTO sysTenantVO;
    private List<SysOrgBasicDTO> orgList;
    private SysOrgBasicDTO org;
    private SysOrgBasicDTO tenantOrg;
    private IdCodeNameParam position;
    private Long tenantOrgAdminId;
    private String remark;
    private Long employeeId;
    private List<SysUserType> userTypeList;
    private List<SysUnderlingDTO> underlingList;
    private Object extend;

    public Long getTenantId() {
        if (this.sysTenantVO != null) {
            return this.sysTenantVO.getId();
        }
        return this.tenantId;
    }

    public Long getTenantOrgId() {
        if (this.tenantOrg == null) {
            return null;
        }
        return this.tenantOrg.getId();
    }

    public String getPrettyName() {
        StringBuilder result = new StringBuilder();
        if (this.getLastName() != null) {
            result.append(this.getLastName());
        }
        if (this.getFirstName() != null) {
            result.append(this.getFirstName());
        }
        return result.toString();
    }

    public Integer getRemainingDaysOfPwd() {
        if (this.pwdExpiredTime == null) {
            return null;
        }
        return Math.toIntExact(Duration.between(LocalDateTime.now(), this.pwdExpiredTime).toDays());
    }

    public Set<Long> getRoleIds() {
        if (CollectionUtils.isEmpty(this.roles)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> roleIds = new HashSet<Long>(this.roles.size());
        for (IdCodeNameParam role : this.roles) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }

    public static SysUserDTOBuilder builder() {
        return new SysUserDTOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getOuId() {
        return this.ouId;
    }

    public String getOuCode() {
        return this.ouCode;
    }

    public String getOuName() {
        return this.ouName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public Long getCasUserId() {
        return this.casUserId;
    }

    public String getWxOpenid() {
        return this.wxOpenid;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getNeedReset() {
        return this.needReset;
    }

    public LocalDateTime getExpiredTime() {
        return this.expiredTime;
    }

    public LocalDateTime getPwdExpiredTime() {
        return this.pwdExpiredTime;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    @Deprecated
    public String getUserType() {
        return this.userType;
    }

    public Set<String> getRoleCodes() {
        return this.roleCodes;
    }

    public List<IdCodeNameParam> getRoles() {
        return this.roles;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getAvatarCode() {
        return this.avatarCode;
    }

    @Deprecated
    public List<Terminal> getTerminals() {
        return this.terminals;
    }

    public List<SysTenantDTO> getSysTenantDTOList() {
        return this.sysTenantDTOList;
    }

    public SysTenantDTO getSysTenantVO() {
        return this.sysTenantVO;
    }

    public List<SysOrgBasicDTO> getOrgList() {
        return this.orgList;
    }

    public SysOrgBasicDTO getOrg() {
        return this.org;
    }

    public SysOrgBasicDTO getTenantOrg() {
        return this.tenantOrg;
    }

    public IdCodeNameParam getPosition() {
        return this.position;
    }

    public Long getTenantOrgAdminId() {
        return this.tenantOrgAdminId;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getEmployeeId() {
        return this.employeeId;
    }

    public List<SysUserType> getUserTypeList() {
        return this.userTypeList;
    }

    public List<SysUnderlingDTO> getUnderlingList() {
        return this.underlingList;
    }

    public Object getExtend() {
        return this.extend;
    }

    public SysUserDTO setId(Long id) {
        this.id = id;
        return this;
    }

    public SysUserDTO setTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public SysUserDTO setOuId(Long ouId) {
        this.ouId = ouId;
        return this;
    }

    public SysUserDTO setOuCode(String ouCode) {
        this.ouCode = ouCode;
        return this;
    }

    public SysUserDTO setOuName(String ouName) {
        this.ouName = ouName;
        return this;
    }

    public SysUserDTO setUsername(String username) {
        this.username = username;
        return this;
    }

    public SysUserDTO setPassword(String password) {
        this.password = password;
        return this;
    }

    public SysUserDTO setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public SysUserDTO setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public SysUserDTO setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public SysUserDTO setEmail(String email) {
        this.email = email;
        return this;
    }

    public SysUserDTO setCasUserId(Long casUserId) {
        this.casUserId = casUserId;
        return this;
    }

    public SysUserDTO setWxOpenid(String wxOpenid) {
        this.wxOpenid = wxOpenid;
        return this;
    }

    public SysUserDTO setSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public SysUserDTO setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SysUserDTO setNeedReset(Boolean needReset) {
        this.needReset = needReset;
        return this;
    }

    public SysUserDTO setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
        return this;
    }

    public SysUserDTO setPwdExpiredTime(LocalDateTime pwdExpiredTime) {
        this.pwdExpiredTime = pwdExpiredTime;
        return this;
    }

    public SysUserDTO setLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Deprecated
    public SysUserDTO setUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public SysUserDTO setRoleCodes(Set<String> roleCodes) {
        this.roleCodes = roleCodes;
        return this;
    }

    public SysUserDTO setRoleIds(Set<Long> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public SysUserDTO setRoles(List<IdCodeNameParam> roles) {
        this.roles = roles;
        return this;
    }

    public SysUserDTO setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    public SysUserDTO setAvatarCode(String avatarCode) {
        this.avatarCode = avatarCode;
        return this;
    }

    @Deprecated
    public SysUserDTO setTerminals(List<Terminal> terminals) {
        this.terminals = terminals;
        return this;
    }

    public SysUserDTO setSysTenantDTOList(List<SysTenantDTO> sysTenantDTOList) {
        this.sysTenantDTOList = sysTenantDTOList;
        return this;
    }

    public SysUserDTO setSysTenantVO(SysTenantDTO sysTenantVO) {
        this.sysTenantVO = sysTenantVO;
        return this;
    }

    public SysUserDTO setOrgList(List<SysOrgBasicDTO> orgList) {
        this.orgList = orgList;
        return this;
    }

    public SysUserDTO setOrg(SysOrgBasicDTO org) {
        this.org = org;
        return this;
    }

    public SysUserDTO setTenantOrg(SysOrgBasicDTO tenantOrg) {
        this.tenantOrg = tenantOrg;
        return this;
    }

    public SysUserDTO setPosition(IdCodeNameParam position) {
        this.position = position;
        return this;
    }

    public SysUserDTO setTenantOrgAdminId(Long tenantOrgAdminId) {
        this.tenantOrgAdminId = tenantOrgAdminId;
        return this;
    }

    public SysUserDTO setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public SysUserDTO setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    public SysUserDTO setUserTypeList(List<SysUserType> userTypeList) {
        this.userTypeList = userTypeList;
        return this;
    }

    public SysUserDTO setUnderlingList(List<SysUnderlingDTO> underlingList) {
        this.underlingList = underlingList;
        return this;
    }

    public SysUserDTO setExtend(Object extend) {
        this.extend = extend;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysUserDTO)) {
            return false;
        }
        SysUserDTO other = (SysUserDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tenantId = this.getTenantId();
        Long other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        Long this$ouId = this.getOuId();
        Long other$ouId = other.getOuId();
        if (this$ouId == null ? other$ouId != null : !((Object)this$ouId).equals(other$ouId)) {
            return false;
        }
        Long this$casUserId = this.getCasUserId();
        Long other$casUserId = other.getCasUserId();
        if (this$casUserId == null ? other$casUserId != null : !((Object)this$casUserId).equals(other$casUserId)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$needReset = this.getNeedReset();
        Boolean other$needReset = other.getNeedReset();
        if (this$needReset == null ? other$needReset != null : !((Object)this$needReset).equals(other$needReset)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        Long this$tenantOrgAdminId = this.getTenantOrgAdminId();
        Long other$tenantOrgAdminId = other.getTenantOrgAdminId();
        if (this$tenantOrgAdminId == null ? other$tenantOrgAdminId != null : !((Object)this$tenantOrgAdminId).equals(other$tenantOrgAdminId)) {
            return false;
        }
        Long this$employeeId = this.getEmployeeId();
        Long other$employeeId = other.getEmployeeId();
        if (this$employeeId == null ? other$employeeId != null : !((Object)this$employeeId).equals(other$employeeId)) {
            return false;
        }
        String this$ouCode = this.getOuCode();
        String other$ouCode = other.getOuCode();
        if (this$ouCode == null ? other$ouCode != null : !this$ouCode.equals(other$ouCode)) {
            return false;
        }
        String this$ouName = this.getOuName();
        String other$ouName = other.getOuName();
        if (this$ouName == null ? other$ouName != null : !this$ouName.equals(other$ouName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$wxOpenid = this.getWxOpenid();
        String other$wxOpenid = other.getWxOpenid();
        if (this$wxOpenid == null ? other$wxOpenid != null : !this$wxOpenid.equals(other$wxOpenid)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        LocalDateTime this$expiredTime = this.getExpiredTime();
        LocalDateTime other$expiredTime = other.getExpiredTime();
        if (this$expiredTime == null ? other$expiredTime != null : !((Object)this$expiredTime).equals(other$expiredTime)) {
            return false;
        }
        LocalDateTime this$pwdExpiredTime = this.getPwdExpiredTime();
        LocalDateTime other$pwdExpiredTime = other.getPwdExpiredTime();
        if (this$pwdExpiredTime == null ? other$pwdExpiredTime != null : !((Object)this$pwdExpiredTime).equals(other$pwdExpiredTime)) {
            return false;
        }
        String this$userType = this.getUserType();
        String other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !this$userType.equals(other$userType)) {
            return false;
        }
        Set<String> this$roleCodes = this.getRoleCodes();
        Set<String> other$roleCodes = other.getRoleCodes();
        if (this$roleCodes == null ? other$roleCodes != null : !((Object)this$roleCodes).equals(other$roleCodes)) {
            return false;
        }
        Set<Long> this$roleIds = this.getRoleIds();
        Set<Long> other$roleIds = other.getRoleIds();
        if (this$roleIds == null ? other$roleIds != null : !((Object)this$roleIds).equals(other$roleIds)) {
            return false;
        }
        List<IdCodeNameParam> this$roles = this.getRoles();
        List<IdCodeNameParam> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$avatarUrl = this.getAvatarUrl();
        String other$avatarUrl = other.getAvatarUrl();
        if (this$avatarUrl == null ? other$avatarUrl != null : !this$avatarUrl.equals(other$avatarUrl)) {
            return false;
        }
        String this$avatarCode = this.getAvatarCode();
        String other$avatarCode = other.getAvatarCode();
        if (this$avatarCode == null ? other$avatarCode != null : !this$avatarCode.equals(other$avatarCode)) {
            return false;
        }
        List<Terminal> this$terminals = this.getTerminals();
        List<Terminal> other$terminals = other.getTerminals();
        if (this$terminals == null ? other$terminals != null : !((Object)this$terminals).equals(other$terminals)) {
            return false;
        }
        List<SysTenantDTO> this$sysTenantDTOList = this.getSysTenantDTOList();
        List<SysTenantDTO> other$sysTenantDTOList = other.getSysTenantDTOList();
        if (this$sysTenantDTOList == null ? other$sysTenantDTOList != null : !((Object)this$sysTenantDTOList).equals(other$sysTenantDTOList)) {
            return false;
        }
        SysTenantDTO this$sysTenantVO = this.getSysTenantVO();
        SysTenantDTO other$sysTenantVO = other.getSysTenantVO();
        if (this$sysTenantVO == null ? other$sysTenantVO != null : !((Object)this$sysTenantVO).equals(other$sysTenantVO)) {
            return false;
        }
        List<SysOrgBasicDTO> this$orgList = this.getOrgList();
        List<SysOrgBasicDTO> other$orgList = other.getOrgList();
        if (this$orgList == null ? other$orgList != null : !((Object)this$orgList).equals(other$orgList)) {
            return false;
        }
        SysOrgBasicDTO this$org = this.getOrg();
        SysOrgBasicDTO other$org = other.getOrg();
        if (this$org == null ? other$org != null : !((Object)this$org).equals(other$org)) {
            return false;
        }
        SysOrgBasicDTO this$tenantOrg = this.getTenantOrg();
        SysOrgBasicDTO other$tenantOrg = other.getTenantOrg();
        if (this$tenantOrg == null ? other$tenantOrg != null : !((Object)this$tenantOrg).equals(other$tenantOrg)) {
            return false;
        }
        IdCodeNameParam this$position = this.getPosition();
        IdCodeNameParam other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        List<SysUserType> this$userTypeList = this.getUserTypeList();
        List<SysUserType> other$userTypeList = other.getUserTypeList();
        if (this$userTypeList == null ? other$userTypeList != null : !((Object)this$userTypeList).equals(other$userTypeList)) {
            return false;
        }
        List<SysUnderlingDTO> this$underlingList = this.getUnderlingList();
        List<SysUnderlingDTO> other$underlingList = other.getUnderlingList();
        if (this$underlingList == null ? other$underlingList != null : !((Object)this$underlingList).equals(other$underlingList)) {
            return false;
        }
        Object this$extend = this.getExtend();
        Object other$extend = other.getExtend();
        return !(this$extend == null ? other$extend != null : !this$extend.equals(other$extend));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysUserDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        Long $ouId = this.getOuId();
        result = result * 59 + ($ouId == null ? 43 : ((Object)$ouId).hashCode());
        Long $casUserId = this.getCasUserId();
        result = result * 59 + ($casUserId == null ? 43 : ((Object)$casUserId).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $needReset = this.getNeedReset();
        result = result * 59 + ($needReset == null ? 43 : ((Object)$needReset).hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        Long $tenantOrgAdminId = this.getTenantOrgAdminId();
        result = result * 59 + ($tenantOrgAdminId == null ? 43 : ((Object)$tenantOrgAdminId).hashCode());
        Long $employeeId = this.getEmployeeId();
        result = result * 59 + ($employeeId == null ? 43 : ((Object)$employeeId).hashCode());
        String $ouCode = this.getOuCode();
        result = result * 59 + ($ouCode == null ? 43 : $ouCode.hashCode());
        String $ouName = this.getOuName();
        result = result * 59 + ($ouName == null ? 43 : $ouName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $wxOpenid = this.getWxOpenid();
        result = result * 59 + ($wxOpenid == null ? 43 : $wxOpenid.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        LocalDateTime $expiredTime = this.getExpiredTime();
        result = result * 59 + ($expiredTime == null ? 43 : ((Object)$expiredTime).hashCode());
        LocalDateTime $pwdExpiredTime = this.getPwdExpiredTime();
        result = result * 59 + ($pwdExpiredTime == null ? 43 : ((Object)$pwdExpiredTime).hashCode());
        String $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : $userType.hashCode());
        Set<String> $roleCodes = this.getRoleCodes();
        result = result * 59 + ($roleCodes == null ? 43 : ((Object)$roleCodes).hashCode());
        Set<Long> $roleIds = this.getRoleIds();
        result = result * 59 + ($roleIds == null ? 43 : ((Object)$roleIds).hashCode());
        List<IdCodeNameParam> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $avatarUrl = this.getAvatarUrl();
        result = result * 59 + ($avatarUrl == null ? 43 : $avatarUrl.hashCode());
        String $avatarCode = this.getAvatarCode();
        result = result * 59 + ($avatarCode == null ? 43 : $avatarCode.hashCode());
        List<Terminal> $terminals = this.getTerminals();
        result = result * 59 + ($terminals == null ? 43 : ((Object)$terminals).hashCode());
        List<SysTenantDTO> $sysTenantDTOList = this.getSysTenantDTOList();
        result = result * 59 + ($sysTenantDTOList == null ? 43 : ((Object)$sysTenantDTOList).hashCode());
        SysTenantDTO $sysTenantVO = this.getSysTenantVO();
        result = result * 59 + ($sysTenantVO == null ? 43 : ((Object)$sysTenantVO).hashCode());
        List<SysOrgBasicDTO> $orgList = this.getOrgList();
        result = result * 59 + ($orgList == null ? 43 : ((Object)$orgList).hashCode());
        SysOrgBasicDTO $org = this.getOrg();
        result = result * 59 + ($org == null ? 43 : ((Object)$org).hashCode());
        SysOrgBasicDTO $tenantOrg = this.getTenantOrg();
        result = result * 59 + ($tenantOrg == null ? 43 : ((Object)$tenantOrg).hashCode());
        IdCodeNameParam $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        List<SysUserType> $userTypeList = this.getUserTypeList();
        result = result * 59 + ($userTypeList == null ? 43 : ((Object)$userTypeList).hashCode());
        List<SysUnderlingDTO> $underlingList = this.getUnderlingList();
        result = result * 59 + ($underlingList == null ? 43 : ((Object)$underlingList).hashCode());
        Object $extend = this.getExtend();
        result = result * 59 + ($extend == null ? 43 : $extend.hashCode());
        return result;
    }

    public String toString() {
        return "SysUserDTO(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", ouId=" + this.getOuId() + ", ouCode=" + this.getOuCode() + ", ouName=" + this.getOuName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", lastName=" + this.getLastName() + ", firstName=" + this.getFirstName() + ", mobile=" + this.getMobile() + ", email=" + this.getEmail() + ", casUserId=" + this.getCasUserId() + ", wxOpenid=" + this.getWxOpenid() + ", sourceType=" + this.getSourceType() + ", enabled=" + this.getEnabled() + ", needReset=" + this.getNeedReset() + ", expiredTime=" + this.getExpiredTime() + ", pwdExpiredTime=" + this.getPwdExpiredTime() + ", locked=" + this.getLocked() + ", userType=" + this.getUserType() + ", roleCodes=" + this.getRoleCodes() + ", roleIds=" + this.getRoleIds() + ", roles=" + this.getRoles() + ", avatarUrl=" + this.getAvatarUrl() + ", avatarCode=" + this.getAvatarCode() + ", terminals=" + this.getTerminals() + ", sysTenantDTOList=" + this.getSysTenantDTOList() + ", sysTenantVO=" + this.getSysTenantVO() + ", orgList=" + this.getOrgList() + ", org=" + this.getOrg() + ", tenantOrg=" + this.getTenantOrg() + ", position=" + this.getPosition() + ", tenantOrgAdminId=" + this.getTenantOrgAdminId() + ", remark=" + this.getRemark() + ", employeeId=" + this.getEmployeeId() + ", userTypeList=" + this.getUserTypeList() + ", underlingList=" + this.getUnderlingList() + ", extend=" + this.getExtend() + ")";
    }

    public SysUserDTO() {
    }

    public SysUserDTO(Long id, Long tenantId, Long ouId, String ouCode, String ouName, String username, String password, String lastName, String firstName, String mobile, String email, Long casUserId, String wxOpenid, String sourceType, Boolean enabled, Boolean needReset, LocalDateTime expiredTime, LocalDateTime pwdExpiredTime, Boolean locked, String userType, Set<String> roleCodes, Set<Long> roleIds, List<IdCodeNameParam> roles, String avatarUrl, String avatarCode, List<Terminal> terminals, List<SysTenantDTO> sysTenantDTOList, SysTenantDTO sysTenantVO, List<SysOrgBasicDTO> orgList, SysOrgBasicDTO org, SysOrgBasicDTO tenantOrg, IdCodeNameParam position, Long tenantOrgAdminId, String remark, Long employeeId, List<SysUserType> userTypeList, List<SysUnderlingDTO> underlingList, Object extend) {
        this.id = id;
        this.tenantId = tenantId;
        this.ouId = ouId;
        this.ouCode = ouCode;
        this.ouName = ouName;
        this.username = username;
        this.password = password;
        this.lastName = lastName;
        this.firstName = firstName;
        this.mobile = mobile;
        this.email = email;
        this.casUserId = casUserId;
        this.wxOpenid = wxOpenid;
        this.sourceType = sourceType;
        this.enabled = enabled;
        this.needReset = needReset;
        this.expiredTime = expiredTime;
        this.pwdExpiredTime = pwdExpiredTime;
        this.locked = locked;
        this.userType = userType;
        this.roleCodes = roleCodes;
        this.roleIds = roleIds;
        this.roles = roles;
        this.avatarUrl = avatarUrl;
        this.avatarCode = avatarCode;
        this.terminals = terminals;
        this.sysTenantDTOList = sysTenantDTOList;
        this.sysTenantVO = sysTenantVO;
        this.orgList = orgList;
        this.org = org;
        this.tenantOrg = tenantOrg;
        this.position = position;
        this.tenantOrgAdminId = tenantOrgAdminId;
        this.remark = remark;
        this.employeeId = employeeId;
        this.userTypeList = userTypeList;
        this.underlingList = underlingList;
        this.extend = extend;
    }

    public static class SysUserDTOBuilder {
        private Long id;
        private Long tenantId;
        private Long ouId;
        private String ouCode;
        private String ouName;
        private String username;
        private String password;
        private String lastName;
        private String firstName;
        private String mobile;
        private String email;
        private Long casUserId;
        private String wxOpenid;
        private String sourceType;
        private Boolean enabled;
        private Boolean needReset;
        private LocalDateTime expiredTime;
        private LocalDateTime pwdExpiredTime;
        private Boolean locked;
        private String userType;
        private Set<String> roleCodes;
        private Set<Long> roleIds;
        private List<IdCodeNameParam> roles;
        private String avatarUrl;
        private String avatarCode;
        private List<Terminal> terminals;
        private List<SysTenantDTO> sysTenantDTOList;
        private SysTenantDTO sysTenantVO;
        private List<SysOrgBasicDTO> orgList;
        private SysOrgBasicDTO org;
        private SysOrgBasicDTO tenantOrg;
        private IdCodeNameParam position;
        private Long tenantOrgAdminId;
        private String remark;
        private Long employeeId;
        private List<SysUserType> userTypeList;
        private List<SysUnderlingDTO> underlingList;
        private Object extend;

        SysUserDTOBuilder() {
        }

        public SysUserDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SysUserDTOBuilder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SysUserDTOBuilder ouId(Long ouId) {
            this.ouId = ouId;
            return this;
        }

        public SysUserDTOBuilder ouCode(String ouCode) {
            this.ouCode = ouCode;
            return this;
        }

        public SysUserDTOBuilder ouName(String ouName) {
            this.ouName = ouName;
            return this;
        }

        public SysUserDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SysUserDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SysUserDTOBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public SysUserDTOBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public SysUserDTOBuilder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public SysUserDTOBuilder email(String email) {
            this.email = email;
            return this;
        }

        public SysUserDTOBuilder casUserId(Long casUserId) {
            this.casUserId = casUserId;
            return this;
        }

        public SysUserDTOBuilder wxOpenid(String wxOpenid) {
            this.wxOpenid = wxOpenid;
            return this;
        }

        public SysUserDTOBuilder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public SysUserDTOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SysUserDTOBuilder needReset(Boolean needReset) {
            this.needReset = needReset;
            return this;
        }

        public SysUserDTOBuilder expiredTime(LocalDateTime expiredTime) {
            this.expiredTime = expiredTime;
            return this;
        }

        public SysUserDTOBuilder pwdExpiredTime(LocalDateTime pwdExpiredTime) {
            this.pwdExpiredTime = pwdExpiredTime;
            return this;
        }

        public SysUserDTOBuilder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        @Deprecated
        public SysUserDTOBuilder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public SysUserDTOBuilder roleCodes(Set<String> roleCodes) {
            this.roleCodes = roleCodes;
            return this;
        }

        public SysUserDTOBuilder roleIds(Set<Long> roleIds) {
            this.roleIds = roleIds;
            return this;
        }

        public SysUserDTOBuilder roles(List<IdCodeNameParam> roles) {
            this.roles = roles;
            return this;
        }

        public SysUserDTOBuilder avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        public SysUserDTOBuilder avatarCode(String avatarCode) {
            this.avatarCode = avatarCode;
            return this;
        }

        @Deprecated
        public SysUserDTOBuilder terminals(List<Terminal> terminals) {
            this.terminals = terminals;
            return this;
        }

        public SysUserDTOBuilder sysTenantDTOList(List<SysTenantDTO> sysTenantDTOList) {
            this.sysTenantDTOList = sysTenantDTOList;
            return this;
        }

        public SysUserDTOBuilder sysTenantVO(SysTenantDTO sysTenantVO) {
            this.sysTenantVO = sysTenantVO;
            return this;
        }

        public SysUserDTOBuilder orgList(List<SysOrgBasicDTO> orgList) {
            this.orgList = orgList;
            return this;
        }

        public SysUserDTOBuilder org(SysOrgBasicDTO org) {
            this.org = org;
            return this;
        }

        public SysUserDTOBuilder tenantOrg(SysOrgBasicDTO tenantOrg) {
            this.tenantOrg = tenantOrg;
            return this;
        }

        public SysUserDTOBuilder position(IdCodeNameParam position) {
            this.position = position;
            return this;
        }

        public SysUserDTOBuilder tenantOrgAdminId(Long tenantOrgAdminId) {
            this.tenantOrgAdminId = tenantOrgAdminId;
            return this;
        }

        public SysUserDTOBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public SysUserDTOBuilder employeeId(Long employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public SysUserDTOBuilder userTypeList(List<SysUserType> userTypeList) {
            this.userTypeList = userTypeList;
            return this;
        }

        public SysUserDTOBuilder underlingList(List<SysUnderlingDTO> underlingList) {
            this.underlingList = underlingList;
            return this;
        }

        public SysUserDTOBuilder extend(Object extend) {
            this.extend = extend;
            return this;
        }

        public SysUserDTO build() {
            return new SysUserDTO(this.id, this.tenantId, this.ouId, this.ouCode, this.ouName, this.username, this.password, this.lastName, this.firstName, this.mobile, this.email, this.casUserId, this.wxOpenid, this.sourceType, this.enabled, this.needReset, this.expiredTime, this.pwdExpiredTime, this.locked, this.userType, this.roleCodes, this.roleIds, this.roles, this.avatarUrl, this.avatarCode, this.terminals, this.sysTenantDTOList, this.sysTenantVO, this.orgList, this.org, this.tenantOrg, this.position, this.tenantOrgAdminId, this.remark, this.employeeId, this.userTypeList, this.underlingList, this.extend);
        }

        public String toString() {
            return "SysUserDTO.SysUserDTOBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", ouId=" + this.ouId + ", ouCode=" + this.ouCode + ", ouName=" + this.ouName + ", username=" + this.username + ", password=" + this.password + ", lastName=" + this.lastName + ", firstName=" + this.firstName + ", mobile=" + this.mobile + ", email=" + this.email + ", casUserId=" + this.casUserId + ", wxOpenid=" + this.wxOpenid + ", sourceType=" + this.sourceType + ", enabled=" + this.enabled + ", needReset=" + this.needReset + ", expiredTime=" + this.expiredTime + ", pwdExpiredTime=" + this.pwdExpiredTime + ", locked=" + this.locked + ", userType=" + this.userType + ", roleCodes=" + this.roleCodes + ", roleIds=" + this.roleIds + ", roles=" + this.roles + ", avatarUrl=" + this.avatarUrl + ", avatarCode=" + this.avatarCode + ", terminals=" + this.terminals + ", sysTenantDTOList=" + this.sysTenantDTOList + ", sysTenantVO=" + this.sysTenantVO + ", orgList=" + this.orgList + ", org=" + this.org + ", tenantOrg=" + this.tenantOrg + ", position=" + this.position + ", tenantOrgAdminId=" + this.tenantOrgAdminId + ", remark=" + this.remark + ", employeeId=" + this.employeeId + ", userTypeList=" + this.userTypeList + ", underlingList=" + this.underlingList + ", extend=" + this.extend + ")";
        }
    }
}

