/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.security.entity;

import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class GeneralUserDetails
implements UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = 414652772107486653L;
    private List<GrantedAuthority> authorities;
    private SysUserDTO user;
    private String ip;
    private String browser;
    private String address;
    private String locale;
    @Deprecated
    private List<Long> selfBuIds;
    @Deprecated
    private List<Long> grantedBuIds;
    private Object extendInfo;

    public GeneralUserDetails() {
    }

    public GeneralUserDetails(SysUserDTO sysUserDTO) {
        this.user = sysUserDTO;
    }

    public List<String> getRoleCodes() {
        if (this.user.getRoleCodes() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.user.getRoleCodes());
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.user.getRoleCodes() == null) {
            return Collections.emptyList();
        }
        return this.user.getRoleCodes().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    @JsonIgnore
    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.user.getExpiredTime() == null || this.user.getExpiredTime().isAfter(LocalDateTime.now());
    }

    public boolean isAccountNonLocked() {
        return !Boolean.TRUE.equals(this.user.getLocked());
    }

    public boolean isCredentialsNonExpired() {
        if (this.user.getPwdExpiredTime() == null) {
            return true;
        }
        return LocalDateTime.now().isBefore(this.user.getPwdExpiredTime());
    }

    public boolean isEnabled() {
        return this.user.getEnabled() != null && this.user.getEnabled() != false;
    }

    public void eraseCredentials() {
        this.user.setPassword(null);
    }

    public Long getUserId() {
        return this.getUser().getId();
    }

    public Long getOrgId() {
        if (this.user.getOrg() == null) {
            return null;
        }
        return this.user.getOrg().getId();
    }

    public Long getTenantOrgId() {
        if (this.user.getTenantOrg() == null) {
            return null;
        }
        return this.user.getTenantOrg().getId();
    }

    public boolean isSystemAdmin() {
        return InnerUserEnum.ADMIN.getUsername().equals(this.getUsername());
    }

    public boolean isTenantAdmin() {
        return this.getTenant() != null && Objects.equals(this.getUserId(), this.getTenant().getSysUserId());
    }

    public boolean isTenantOrgAdmin() {
        if (this.user.getTenantOrgAdminId() == null) {
            return false;
        }
        return this.user.getTenantOrgAdminId().longValue() == this.user.getId().longValue();
    }

    public boolean isTenantUser() {
        return this.getTenant() != null && !Objects.equals(this.getUserId(), this.getTenant().getSysUserId()) && this.getTenant().getType() != TenantType.OPERATION;
    }

    public boolean isOperation() {
        if (this.isSystemAdmin()) {
            return true;
        }
        return this.getTenant() != null && this.getTenant().getType() == TenantType.OPERATION;
    }

    public boolean isCommonUser() {
        return this.getTenant() == null && !InnerUserEnum.ADMIN.getUsername().equals(this.getUsername());
    }

    public SysTenantDTO getTenant() {
        return this.user.getSysTenantVO();
    }

    public Long getTenantId() {
        if (this.user.getSysTenantVO() == null) {
            return null;
        }
        return this.user.getSysTenantVO().getId();
    }

    public boolean hasUserType(String userType) {
        if (userType == null) {
            return false;
        }
        if (this.user == null || CollectionUtil.isEmpty(this.user.getUserTypeList())) {
            return false;
        }
        for (SysUserType sysUserType : this.user.getUserTypeList()) {
            if (!userType.equals(sysUserType.getUserType())) continue;
            return true;
        }
        return false;
    }

    public String getUserTypeIdentity(String userType) {
        if (userType == null) {
            return null;
        }
        if (this.user == null || CollectionUtil.isEmpty(this.user.getUserTypeList())) {
            return null;
        }
        for (SysUserType sysUserType : this.user.getUserTypeList()) {
            if (!userType.equals(sysUserType.getUserType())) continue;
            return sysUserType.getIdentityId();
        }
        return null;
    }

    public SysUserDTO getUser() {
        return this.user;
    }

    public String getIp() {
        return this.ip;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLocale() {
        return this.locale;
    }

    @Deprecated
    public List<Long> getSelfBuIds() {
        return this.selfBuIds;
    }

    @Deprecated
    public List<Long> getGrantedBuIds() {
        return this.grantedBuIds;
    }

    public Object getExtendInfo() {
        return this.extendInfo;
    }

    public GeneralUserDetails setAuthorities(List<GrantedAuthority> authorities) {
        this.authorities = authorities;
        return this;
    }

    public GeneralUserDetails setUser(SysUserDTO user) {
        this.user = user;
        return this;
    }

    public GeneralUserDetails setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public GeneralUserDetails setBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public GeneralUserDetails setAddress(String address) {
        this.address = address;
        return this;
    }

    public GeneralUserDetails setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Deprecated
    public GeneralUserDetails setSelfBuIds(List<Long> selfBuIds) {
        this.selfBuIds = selfBuIds;
        return this;
    }

    @Deprecated
    public GeneralUserDetails setGrantedBuIds(List<Long> grantedBuIds) {
        this.grantedBuIds = grantedBuIds;
        return this;
    }

    public GeneralUserDetails setExtendInfo(Object extendInfo) {
        this.extendInfo = extendInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralUserDetails)) {
            return false;
        }
        GeneralUserDetails other = (GeneralUserDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<? extends GrantedAuthority> this$authorities = this.getAuthorities();
        Collection<? extends GrantedAuthority> other$authorities = other.getAuthorities();
        if (this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities)) {
            return false;
        }
        SysUserDTO this$user = this.getUser();
        SysUserDTO other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$browser = this.getBrowser();
        String other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        List<Long> this$selfBuIds = this.getSelfBuIds();
        List<Long> other$selfBuIds = other.getSelfBuIds();
        if (this$selfBuIds == null ? other$selfBuIds != null : !((Object)this$selfBuIds).equals(other$selfBuIds)) {
            return false;
        }
        List<Long> this$grantedBuIds = this.getGrantedBuIds();
        List<Long> other$grantedBuIds = other.getGrantedBuIds();
        if (this$grantedBuIds == null ? other$grantedBuIds != null : !((Object)this$grantedBuIds).equals(other$grantedBuIds)) {
            return false;
        }
        Object this$extendInfo = this.getExtendInfo();
        Object other$extendInfo = other.getExtendInfo();
        return !(this$extendInfo == null ? other$extendInfo != null : !this$extendInfo.equals(other$extendInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralUserDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<? extends GrantedAuthority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        SysUserDTO $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        List<Long> $selfBuIds = this.getSelfBuIds();
        result = result * 59 + ($selfBuIds == null ? 43 : ((Object)$selfBuIds).hashCode());
        List<Long> $grantedBuIds = this.getGrantedBuIds();
        result = result * 59 + ($grantedBuIds == null ? 43 : ((Object)$grantedBuIds).hashCode());
        Object $extendInfo = this.getExtendInfo();
        result = result * 59 + ($extendInfo == null ? 43 : $extendInfo.hashCode());
        return result;
    }

    public String toString() {
        return "GeneralUserDetails(authorities=" + this.getAuthorities() + ", user=" + this.getUser() + ", ip=" + this.getIp() + ", browser=" + this.getBrowser() + ", address=" + this.getAddress() + ", locale=" + this.getLocale() + ", selfBuIds=" + this.getSelfBuIds() + ", grantedBuIds=" + this.getGrantedBuIds() + ", extendInfo=" + this.getExtendInfo() + ")";
    }
}

