/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.terms.AbstractCronTerm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DayCronTerm
extends AbstractCronTerm {
    private Boolean every;
    private Boolean notAssign;
    private Set<Integer> specificValues;
    private AbstractCronTerm.RangeValue rangeValue;
    private AbstractCronTerm.RateValue rateValue;
    private Integer recentWorkday;
    private Boolean lastDay;
    private Integer lastDayValue;
    private Boolean lastWorkday;

    public DayCronTerm(CronBuilder cronBuilder) {
        super(cronBuilder);
    }

    public DayCronTerm every() {
        this.every = true;
        return this;
    }

    public DayCronTerm notAssign() {
        this.notAssign = true;
        return this;
    }

    public DayCronTerm of(Integer ... days) {
        if (days == null || days.length == 0) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(Arrays.asList(days));
        return this;
    }

    public DayCronTerm of(List<Integer> days) {
        if (days == null || days.isEmpty()) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(days);
        return this;
    }

    public DayCronTerm ofRange(int start, int end) {
        this.rangeValue = new AbstractCronTerm.RangeValue(start, end);
        return this;
    }

    public DayCronTerm ofRate(int start, int rate) {
        this.rateValue = new AbstractCronTerm.RateValue(start, rate);
        return this;
    }

    public DayCronTerm ofRate(int rate) {
        this.rateValue = new AbstractCronTerm.RateValue(rate);
        return this;
    }

    public DayCronTerm ofRecentWorkday(int recentWorkday) {
        this.recentWorkday = recentWorkday;
        return this;
    }

    public DayCronTerm ofLastDay() {
        this.lastDay = true;
        return this;
    }

    public DayCronTerm ofLastDay(int lastDay) {
        this.lastDayValue = lastDay;
        return this;
    }

    public DayCronTerm ofLastWorkday() {
        this.lastWorkday = true;
        return this;
    }

    @Override
    public String buildExpression() {
        if (Boolean.TRUE.equals(this.every)) {
            return "*";
        }
        if (Boolean.TRUE.equals(this.notAssign)) {
            return "?";
        }
        if (CollUtil.isNotEmpty(this.specificValues)) {
            return this.specificValues.stream().peek(this::validateValue).sorted().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (this.rangeValue != null) {
            this.validateValue(this.rangeValue.getStart());
            this.validateValue(this.rangeValue.getEnd());
            if (this.rangeValue.getStart() > this.rangeValue.getEnd()) {
                throw new IllegalArgumentException("\u65e5\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
            return this.rangeValue.getStart() + "-" + this.rangeValue.getEnd();
        }
        if (this.rateValue != null) {
            if (this.rateValue.getStart() != null) {
                this.validateValue(this.rateValue.getStart());
            }
            this.validateValue(this.rateValue.getRate());
            return ObjUtil.defaultIfNull((Object)this.rateValue.getStart(), (Object)"*") + "/" + this.rateValue.getRate();
        }
        if (this.recentWorkday != null) {
            return this.recentWorkday + "W";
        }
        if (Boolean.TRUE.equals(this.lastDay)) {
            return "L";
        }
        if (this.lastDayValue != null) {
            return "L-" + this.lastDayValue;
        }
        if (Boolean.TRUE.equals(this.lastWorkday)) {
            return "LW";
        }
        return "*";
    }

    private void validateValue(int value) {
        Assert.isTrue((value >= 1 && value <= 31 ? 1 : 0) != 0, (String)"\u65e5\u7684\u503c\u8303\u56f41-31", (Object[])new Object[0]);
    }
}

