/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.terms.AbstractCronTerm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MinuteCronTerm
extends AbstractCronTerm {
    private Boolean every;
    private Set<Integer> specificValues;
    private AbstractCronTerm.RangeValue rangeValue;
    private AbstractCronTerm.RateValue rateValue;

    public MinuteCronTerm(CronBuilder cronBuilder) {
        super(cronBuilder);
    }

    public MinuteCronTerm every() {
        this.every = true;
        return this;
    }

    public MinuteCronTerm of(Integer ... minutes) {
        if (minutes == null || minutes.length == 0) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(Arrays.asList(minutes));
        return this;
    }

    public MinuteCronTerm of(List<Integer> minutes) {
        if (minutes == null || minutes.isEmpty()) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(minutes);
        return this;
    }

    public MinuteCronTerm ofRange(int start, int end) {
        this.rangeValue = new AbstractCronTerm.RangeValue(start, end);
        return this;
    }

    public MinuteCronTerm ofRate(int start, int rate) {
        this.rateValue = new AbstractCronTerm.RateValue(start, rate);
        return this;
    }

    public MinuteCronTerm ofRate(int rate) {
        this.rateValue = new AbstractCronTerm.RateValue(rate);
        return this;
    }

    @Override
    public String buildExpression() {
        if (Boolean.TRUE.equals(this.every)) {
            return "*";
        }
        if (CollUtil.isNotEmpty(this.specificValues)) {
            return this.specificValues.stream().peek(this::validateValue).sorted().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (this.rangeValue != null) {
            this.validateValue(this.rangeValue.getStart());
            this.validateValue(this.rangeValue.getEnd());
            if (this.rangeValue.getStart() > this.rangeValue.getEnd()) {
                throw new IllegalArgumentException("\u5206\u949f\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
            return this.rangeValue.getStart() + "-" + this.rangeValue.getEnd();
        }
        if (this.rateValue != null) {
            if (this.rateValue.getStart() != null) {
                this.validateValue(this.rateValue.getStart());
            }
            this.validateValue(this.rateValue.getRate());
            return ObjUtil.defaultIfNull((Object)this.rateValue.getStart(), (Object)"*") + "/" + this.rateValue.getRate();
        }
        return "0";
    }

    private void validateValue(int value) {
        Assert.isTrue((value >= 0 && value <= 59 ? 1 : 0) != 0, (String)"\u5206\u949f\u7684\u503c\u8303\u56f40-59", (Object[])new Object[0]);
    }
}

