/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util.database;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DatasourceLoadUtil {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(DatasourceLoadUtil.class);

    public static DataSource loadForHikari(Environment environment) {
        DataSource dataSource = DatasourceLoadUtil.loadingSharding(environment);
        if (dataSource == null) {
            dataSource = DatasourceLoadUtil.loadingHikari(environment);
        }
        return dataSource;
    }

    private static DataSource loadingSharding(Environment environment) {
        try {
            Class.forName("org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Boolean enabled = (Boolean)environment.getProperty("spring.shardingsphere.enabled", Boolean.class);
        if (Boolean.FALSE.equals(enabled)) {
            return null;
        }
        String prefix = "spring.shardingsphere.datasource.";
        String datasourceName = environment.getProperty(prefix + "name");
        if (!StringUtils.hasText((String)datasourceName) && StringUtils.hasText((String)(datasourceName = environment.getProperty(prefix + "names")))) {
            datasourceName = datasourceName.split(",")[0];
        }
        if (!StringUtils.hasText((String)datasourceName)) {
            logger.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684sharding\u6570\u636e\u6e90\u540d\u79f0");
            return null;
        }
        String datasourceKey = prefix + datasourceName.trim();
        String datasourceType = environment.getProperty(datasourceKey + ".type");
        Assert.hasText((String)datasourceType, (String)"\u672a\u77e5shardingSphere\u914d\u7f6e\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        Class<?> dataSourceClass = null;
        try {
            dataSourceClass = Class.forName(datasourceType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u6570\u636e\u6e90\u7c7b\u578bclass\uff1a" + datasourceType, e);
        }
        BindResult dataSourceBindResult = Binder.get((Environment)environment).bind(datasourceKey, dataSourceClass);
        if (dataSourceBindResult.isBound()) {
            return (DataSource)dataSourceBindResult.get();
        }
        throw new RuntimeException("\u52a0\u8f7d\u6570\u636e\u6e90\u5931\u8d25");
    }

    private static HikariDataSource loadingHikari(Environment environment) {
        String prefixDatasource = "spring.datasource";
        String prefix = "spring.datasource.hikari";
        String type = environment.getProperty(prefixDatasource + ".type");
        if (!"com.zaxxer.hikari.HikariDataSource".equals(type)) {
            return null;
        }
        BindResult dataSourceBindResult = Binder.get((Environment)environment).bind(prefix, HikariDataSource.class);
        if (dataSourceBindResult.isBound()) {
            String driverClassName;
            String password;
            String username;
            String url;
            HikariDataSource dataSource = (HikariDataSource)dataSourceBindResult.get();
            if (!StringUtils.hasText((String)dataSource.getJdbcUrl()) && StringUtils.hasText((String)(url = environment.getProperty(prefixDatasource + ".url")))) {
                dataSource.setJdbcUrl(url);
            }
            if (!StringUtils.hasText((String)dataSource.getUsername()) && StringUtils.hasText((String)(username = environment.getProperty(prefixDatasource + ".username")))) {
                dataSource.setUsername(username);
            }
            if (!StringUtils.hasText((String)dataSource.getPassword()) && StringUtils.hasText((String)(password = environment.getProperty(prefixDatasource + ".password")))) {
                dataSource.setPassword(password);
            }
            if (!StringUtils.hasText((String)dataSource.getDriverClassName()) && StringUtils.hasText((String)(driverClassName = environment.getProperty(prefixDatasource + ".driver-class-name")))) {
                dataSource.setDriverClassName(driverClassName);
            }
            return dataSource;
        }
        return null;
    }
}

