/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth;

import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AuthorizedClient
implements Serializable {
    private static final long serialVersionUID = -2450603428618865616L;
    private String clientId;
    private List<String> scopes;
    private List<String> tenantCodes;

    public static AuthorizedClient buildByJwt(Jwt jwt) {
        AuthorizedClient authorizedClient = new AuthorizedClient();
        authorizedClient.setClientId(AuthorizedClient.obtainClientId(jwt));
        List scopes = jwt.getClaimAsStringList("scope");
        authorizedClient.setScopes((List)ObjectUtil.defaultIfNull((Object)scopes, Collections.emptyList()));
        String tenantCodeStr = jwt.getClaimAsString("yst_au_tt");
        authorizedClient.setTenantCodes(StringUtils.hasText((String)tenantCodeStr) ? Arrays.stream(tenantCodeStr.split(",")).collect(Collectors.toList()) : Collections.emptyList());
        return authorizedClient;
    }

    private void setClientId(String clientId) {
        this.clientId = clientId;
    }

    private void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    private void setTenantCodes(List<String> tenantCodes) {
        this.tenantCodes = tenantCodes;
    }

    private static String obtainClientId(Jwt jwt) {
        String clientId = jwt.getClaimAsString("yst_cli");
        if (StringUtils.hasText((String)clientId)) {
            return clientId;
        }
        List audience = jwt.getAudience();
        if (!CollectionUtils.isEmpty((Collection)audience)) {
            return (String)audience.get(0);
        }
        return null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getTenantCodes() {
        return this.tenantCodes;
    }
}

