/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot;

import com.elitescloud.boot.common.annotation.validation.validator.EnumValueValidator;
import com.elitescloud.boot.support.CloudtHttpMessagesConverters;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jsonb.JsonbAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;

@AutoConfigureBefore(value={HttpMessageConvertersAutoConfiguration.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class, JacksonAutoConfiguration.class, JsonbAutoConfiguration.class})
class CloudtMessageConvertersAutoConfiguration {
    CloudtMessageConvertersAutoConfiguration() {
    }

    @Bean
    public HttpMessageConverters cloudtHttpMessageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new CloudtHttpMessagesConverters(converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public EnumValueValidator enumValueValidator() {
        return new EnumValueValidator();
    }
}

