/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.util.StringUtils;

public class ValidateUtil {
    private static final Validator VALIDATOR_FAST;
    private static final Validator VALIDATOR_ALL;
    public static final Pattern PATTERN_IP;
    public static final Pattern PATTERN_IP_PORT;
    public static final Pattern PATTERN_MOBILE;
    public static final Pattern PATTERN_EMAIL;
    public static final Pattern PATTERN_PHONE;
    public static final Pattern PATTERN_DATABASE_SCHEMA;
    public static final Pattern PATTERN_DOMAIN;

    public static <T> Set<ConstraintViolation<T>> validateObject(T pojo, boolean fast) {
        return fast ? VALIDATOR_FAST.validate(pojo, new Class[0]) : VALIDATOR_ALL.validate(pojo, new Class[0]);
    }

    public static <T> String validateObjectAndObtainMessage(T pojo, boolean fast) {
        return ValidateUtil.validateObject(pojo, fast).stream().map(ConstraintViolation::getMessage).collect(Collectors.joining("; "));
    }

    public static boolean isMobile(String mobile) {
        return StringUtils.hasText((String)mobile) && PATTERN_MOBILE.matcher(mobile).matches();
    }

    public static boolean isEmail(String email) {
        return StringUtils.hasText((String)email) && PATTERN_EMAIL.matcher(email).matches();
    }

    public static boolean isPhone(String phone) {
        return StringUtils.hasText((String)phone) && PATTERN_PHONE.matcher(phone).matches();
    }

    public static boolean isIp(String ip) {
        return StringUtils.hasText((String)ip) && PATTERN_IP.matcher(ip).matches();
    }

    public static boolean isIpOrIpAndPort(String ip) {
        return StringUtils.hasText((String)ip) && PATTERN_IP_PORT.matcher(ip).matches();
    }

    public static boolean isDomain(String domain) {
        return StringUtils.hasText((String)domain) && PATTERN_DOMAIN.matcher(domain).matches();
    }

    public static boolean isDatabaseSchema(String schema) {
        return StringUtils.hasText((String)schema) && PATTERN_DATABASE_SCHEMA.matcher(schema).matches();
    }

    static {
        ProviderSpecificBootstrap validateProvider = Validation.byProvider(HibernateValidator.class);
        VALIDATOR_FAST = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)validateProvider.configure()).failFast(true)).buildValidatorFactory().getValidator();
        VALIDATOR_ALL = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)validateProvider.configure()).failFast(false)).buildValidatorFactory().getValidator();
        PATTERN_IP = Pattern.compile("((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}");
        PATTERN_IP_PORT = Pattern.compile("((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}(?::([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]))?$");
        PATTERN_MOBILE = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}");
        PATTERN_EMAIL = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
        PATTERN_PHONE = Pattern.compile("(010|02\\d|0[3-9]\\d{2})-?(\\d{6,8})");
        PATTERN_DATABASE_SCHEMA = Pattern.compile("[a-z|0-9|_]+");
        PATTERN_DOMAIN = Pattern.compile("[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\\.?");
    }
}

