/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.ProxyUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.util.ClassUtils;

public class ClassUtil
extends cn.hutool.core.util.ClassUtil {
    public static Class<?> getTargetClass(@NotNull Object bean) {
        return ProxyUtil.getTargetClass(bean);
    }

    public static Type[] getTypeArguments(@NotNull Object obj, @NotNull Class<?> genericInterface) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : ClassUtil.getTargetClass(obj);
        Assert.notNull(genericInterface, (String)"\u6cdb\u578b\u63a5\u53e3\u4e3a\u7a7a", (Object[])new Object[0]);
        while (clazz != null && genericInterface.isAssignableFrom(clazz)) {
            Object[] genericInterfaces = clazz.getGenericInterfaces();
            clazz = clazz.getSuperclass();
            if (ArrayUtil.isEmpty((Object[])genericInterfaces)) continue;
            Class tempClazz = null;
            for (Object inter : genericInterfaces) {
                ParameterizedType paramType = (ParameterizedType)inter;
                if (paramType.getRawType() == genericInterface) {
                    return paramType.getActualTypeArguments();
                }
                if (!genericInterface.isAssignableFrom((Class)paramType.getRawType()) || tempClazz != null) continue;
                tempClazz = (Class)paramType.getRawType();
            }
            if (clazz == null || genericInterface.isAssignableFrom(clazz)) continue;
            clazz = tempClazz;
        }
        return null;
    }

    public static boolean isPresent(@NotBlank String className) {
        return ClassUtil.isPresent(className, null);
    }

    public static boolean isPresent(@NotBlank String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> getClassWithAnnotation(@NotNull Object bean, @NotNull Class<? extends Annotation> annotationClass) {
        Assert.notNull((Object)bean, (String)"\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        return ClassUtil.getClassWithAnnotation(ClassUtil.getTargetClass(bean), annotationClass);
    }

    public static Class<?> getClassWithAnnotation(@NotNull Class<?> clazz, @NotNull Class<? extends Annotation> annotationClass) {
        Assert.notNull(annotationClass, (String)"\u6ce8\u89e3\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList classes = new ArrayList(8);
        ClassUtil.findClassWithParents(clazz, classes, t -> t.isAnnotationPresent(annotationClass));
        return classes.isEmpty() ? null : (Class)classes.get(0);
    }

    public static List<Class<?>> getClassesWithAnnotation(@NotNull Object bean, @NotNull Class<? extends Annotation> annotationClass) {
        Assert.notNull((Object)bean, (String)"\u5bf9\u8c61\u4e3a\u7a7a", (Object[])new Object[0]);
        return ClassUtil.getClassesWithAnnotation(ClassUtil.getTargetClass(bean), annotationClass);
    }

    public static List<Class<?>> getClassesWithAnnotation(@NotNull Class<?> clazz, @NotNull Class<? extends Annotation> annotationClass) {
        Assert.notNull(clazz, (String)"\u7c7b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(annotationClass, (String)"\u6ce8\u89e3\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList classes = new ArrayList(8);
        ClassUtil.findClassWithParents(clazz, classes, t -> t.isAnnotationPresent(annotationClass));
        return classes;
    }

    public static Class<?>[] getMethodArgumentTypes(Method method) {
        Assert.notNull((Object)method, (String)"\u65b9\u6cd5\u4e3a\u7a7a", (Object[])new Object[0]);
        return method.getParameterTypes();
    }

    public static String[] getMethodArgumentTypeNames(Method method) {
        Assert.notNull((Object)method, (String)"\u65b9\u6cd5\u4e3a\u7a7a", (Object[])new Object[0]);
        Object[] parameters = method.getParameterTypes();
        if (ArrayUtil.isEmpty((Object[])parameters)) {
            return new String[0];
        }
        return (String[])Arrays.stream(parameters).map(Class::getCanonicalName).toArray(String[]::new);
    }

    private static void findClassWithParents(@NotNull Class<?> clazz, @NotNull List<Class<?>> parents, Predicate<Class<?>> matcher) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        if (matcher.test(clazz)) {
            parents.add(clazz);
            return;
        }
        Object[] interfaces = clazz.getInterfaces();
        if (ArrayUtil.isNotEmpty((Object[])interfaces)) {
            for (Object anInterface : interfaces) {
                ClassUtil.findClassWithParents(anInterface, parents, matcher);
                if (parents.isEmpty()) continue;
                parents.add(clazz);
                return;
            }
        }
        ClassUtil.findClassWithParents(clazz.getSuperclass(), parents, matcher);
        if (!parents.isEmpty()) {
            parents.add(clazz);
        }
    }
}

