/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class DataSplitterUtil<T> {
    private final Function<Integer, List<T>> dataProducer;
    private final int shardSize;
    private final Function<T, String> masterGenerator;
    private final PaddingMode paddingMode;

    public DataSplitterUtil(@NotNull Function<Integer, List<T>> dataProducer, int shardSize) {
        this(dataProducer, shardSize, null, null);
    }

    public DataSplitterUtil(@NotNull Function<Integer, List<T>> dataProducer, int shardSize, Function<T, String> masterGenerator) {
        this(dataProducer, shardSize, masterGenerator, null);
    }

    public DataSplitterUtil(@NotNull Function<Integer, List<T>> dataProducer, int shardSize, Function<T, String> masterGenerator, PaddingMode paddingMode) {
        this.dataProducer = dataProducer;
        this.shardSize = shardSize;
        this.masterGenerator = masterGenerator;
        this.paddingMode = paddingMode == null ? (masterGenerator == null ? PaddingMode.NOOP : PaddingMode.FORWARD) : paddingMode;
        Assert.isTrue((shardSize > 0 ? 1 : 0) != 0, (String)"\u5206\u7247\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
    }

    public void consume(@NotNull SplitterListener<T> listener) {
        if (this.paddingMode == PaddingMode.NOOP || this.masterGenerator == null) {
            this.consumeForPaddingNoop(listener);
            return;
        }
        if (this.paddingMode == PaddingMode.FORWARD) {
            this.consumeForPaddingForward(listener);
            return;
        }
        if (this.paddingMode == PaddingMode.BACKWARD) {
            this.consumeForPaddingBackWard(listener);
            return;
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u6a21\u5f0f");
    }

    private void consumeForPaddingNoop(SplitterListener<T> listener) {
        this.consumeForBackWard(listener, (records, shardRemainingSize) -> Math.min(records.size(), shardRemainingSize));
    }

    private void consumeForPaddingForward(SplitterListener<T> listener) {
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger shardCount = new AtomicInteger(0);
        int dataQueryTimes = 0;
        AtomicInteger shardIndex = new AtomicInteger(0);
        List<T> records = this.dataProducer.apply(++dataQueryTimes);
        HashSet<String> currentMasterIds = new HashSet<String>();
        while (true) {
            if (CollUtil.isEmpty(records)) {
                if (shardCount.get() > 0) {
                    listener.onShardFinish(shardIndex.get());
                }
                listener.onFinish(count.get());
                return;
            }
            if (shardCount.get() + records.size() <= this.shardSize) {
                this.applyConsumeForForward(records, count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set, currentMasterIds);
                records = this.dataProducer.apply(++dataQueryTimes);
                continue;
            }
            if (this.shardSize > shardCount.get()) {
                List<T> recordsTemp = records.subList(0, this.shardSize - shardCount.get());
                records = records.subList(this.shardSize - shardCount.get(), records.size());
                this.applyConsumeForForward(recordsTemp, count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set, currentMasterIds);
            }
            ArrayList<T> recordsPrev = new ArrayList<T>(records.size());
            ArrayList<T> recordsNext = new ArrayList<T>(records.size());
            for (T record : records) {
                String masterId = this.masterGenerator.apply(record);
                if (currentMasterIds.contains(masterId)) {
                    recordsPrev.add(record);
                    continue;
                }
                recordsNext.add(record);
            }
            if (!recordsPrev.isEmpty()) {
                this.applyConsumeForForward(recordsPrev, count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set, currentMasterIds);
            }
            listener.onShardFinish(shardIndex.get());
            shardCount.set(0);
            shardIndex.incrementAndGet();
            records = recordsNext.isEmpty() ? this.dataProducer.apply(++dataQueryTimes) : recordsNext;
        }
    }

    private void consumeForPaddingBackWard(SplitterListener<T> listener) {
        this.consumeForBackWard(listener, (records, shardRemainingSize) -> {
            if (shardRemainingSize <= 0) {
                return 0;
            }
            ArrayList dataGroupList = new ArrayList();
            String lastMasterId = null;
            ArrayList tempGroupList = null;
            for (Object data : records) {
                String string = this.masterGenerator.apply(data);
                if (!string.equals(lastMasterId)) {
                    if (tempGroupList != null) {
                        dataGroupList.add(tempGroupList);
                    }
                    tempGroupList = new ArrayList();
                    lastMasterId = string;
                }
                tempGroupList.add(data);
            }
            dataGroupList.add(tempGroupList);
            int size = 0;
            for (List list : dataGroupList) {
                if (size + list.size() > shardRemainingSize) {
                    return size;
                }
                size += list.size();
            }
            return size;
        });
    }

    private void consumeForBackWard(SplitterListener<T> listener, BiFunction<List<T>, Integer, Integer> tryConsume) {
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger shardCount = new AtomicInteger(0);
        int dataQueryTimes = 0;
        AtomicInteger shardIndex = new AtomicInteger(0);
        List<T> records = this.dataProducer.apply(++dataQueryTimes);
        while (true) {
            if (CollUtil.isEmpty(records)) {
                if (shardCount.get() > 0) {
                    listener.onShardFinish(shardIndex.get());
                }
                listener.onFinish(count.get());
                return;
            }
            if (shardCount.get() + records.size() <= this.shardSize) {
                this.applyConsumeForBackward(records, count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set);
                records = this.dataProducer.apply(++dataQueryTimes);
                continue;
            }
            int consumeSize = tryConsume.apply(records, this.shardSize - shardCount.get());
            if (consumeSize < 1) {
                listener.onShardFinish(shardIndex.getAndIncrement());
                shardCount.set(0);
                continue;
            }
            if (consumeSize >= records.size()) break;
            this.applyConsumeForBackward(records.subList(0, consumeSize), count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set);
            records = records.subList(consumeSize, records.size());
        }
        this.applyConsumeForBackward(records, count.get(), shardIndex.get(), shardCount.get(), listener, count::set, shardIndex::set, shardCount::set);
    }

    private void applyConsumeForBackward(List<T> records, int count, int shardIndex, int shardCount, SplitterListener<T> listener, Consumer<Integer> countConsumer, Consumer<Integer> shardIndexConsumer, Consumer<Integer> shardCountConsumer) {
        if (CollUtil.isEmpty(records)) {
            return;
        }
        if (shardCount == 0) {
            listener.onShardInitialize(shardIndex);
        }
        listener.onConsume(records);
        countConsumer.accept(count + records.size());
        if (shardCount + records.size() >= this.shardSize) {
            listener.onShardFinish(shardIndex);
            shardIndexConsumer.accept(shardIndex + 1);
            shardCountConsumer.accept(0);
        } else {
            shardCountConsumer.accept(shardCount + records.size());
        }
    }

    private void applyConsumeForForward(List<T> records, int count, int shardIndex, int shardCount, SplitterListener<T> listener, Consumer<Integer> countConsumer, Consumer<Integer> shardIndexConsumer, Consumer<Integer> shardCountConsumer, Set<String> currentMasterIds) {
        if (CollUtil.isEmpty(records)) {
            return;
        }
        if (shardCount == 0) {
            listener.onShardInitialize(shardIndex);
            currentMasterIds.clear();
        }
        listener.onConsume(records);
        currentMasterIds.addAll(records.parallelStream().map(this.masterGenerator).collect(Collectors.toSet()));
        countConsumer.accept(count + records.size());
        shardCountConsumer.accept(shardCount + records.size());
    }

    public static enum PaddingMode {
        NOOP,
        FORWARD,
        BACKWARD;

    }

    public static interface SplitterListener<T> {
        public void onShardInitialize(int var1);

        public void onShardFinish(int var1);

        public void onFinish(long var1);

        public void onConsume(List<T> var1);
    }
}

