/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.common.constant.MimeTypeConstant;
import java.io.File;
import java.io.IOException;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

public class FileUtil
extends cn.hutool.core.io.FileUtil {
    private FileUtil() {
    }

    public static File createTempDir(String ... dirName) {
        File dir;
        if (ArrayUtil.isEmpty((Object[])dirName)) {
            dirName = new String[]{UUID.fastUUID().toString(true) + RandomUtil.randomString((int)4)};
        }
        if (!(dir = new File(System.getProperty("java.io.tmpdir"))).exists()) {
            dir.mkdirs();
        }
        dir = new File(dir, String.join((CharSequence)File.separator, dirName));
        dir.mkdirs();
        return dir;
    }

    public static File createTempFile(String fileName, String ... dirName) {
        File file;
        if (CharSequenceUtil.isBlank((CharSequence)fileName)) {
            fileName = UUID.fastUUID().toString(true) + RandomUtil.randomString((int)4);
        }
        File dir = new File(System.getProperty("java.io.tmpdir"));
        if (ArrayUtil.isNotEmpty((Object[])dirName)) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir = new File(dir, String.join((CharSequence)File.separator, dirName));
            dir.mkdirs();
        }
        if ((file = new File(dir, (String)fileName)).exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
        }
        return file;
    }

    public static String convertMimeTypeByFilename(String filename) {
        if (CharSequenceUtil.isBlank((CharSequence)filename)) {
            return null;
        }
        String mimeType = cn.hutool.core.io.FileUtil.getMimeType((String)filename);
        if (CharSequenceUtil.isBlank((CharSequence)mimeType)) {
            MimeType mime = MimeTypeConstant.getMimeTypeByFilename(filename);
            mimeType = mime == null ? null : mime.toString();
        }
        return mimeType;
    }

    public static MediaType parseMediaType(String mimeType) {
        if (CharSequenceUtil.isBlank((CharSequence)mimeType)) {
            return null;
        }
        String[] types = mimeType.split("/");
        return types.length > 1 ? new MediaType(types[0], types[1]) : new MediaType(types[0]);
    }
}

