/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.StrUtil;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class LockUtil {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(LockUtil.class);
    private static final ConcurrentHashMap<String, Lock> LOCAL_LOCK = new ConcurrentHashMap(512);
    private static RedissonClient redissonClient;
    private static StringRedisTemplate redisTemplate;

    private LockUtil() {
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier) {
        return LockUtil.executeByLock(lockKey, supplier, null);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration) {
        return LockUtil.executeByLock(lockKey, supplier, duration, null);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration, String acquireFailMsg) {
        Assert.hasText((String)lockKey, (String)"\u9501\u7684\u6807\u8bc6\u4e3a\u7a7a");
        if (duration == null) {
            duration = Duration.ofMinutes(10L);
        }
        Lock lockLocal = LOCAL_LOCK.computeIfAbsent(lockKey, c -> new ReentrantLock());
        boolean lockRemote = false;
        try {
            logger.info("\u5c1d\u8bd5\u83b7\u53d6\u672c\u5730\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
            lockRemote = lockLocal.tryLock(duration.getSeconds(), TimeUnit.SECONDS);
            if (lockRemote) {
                logger.info("\u5c1d\u8bd5\u83b7\u53d6\u8fdc\u7a0b\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
                if (LockUtil.tryLock(lockKey, duration.toMillis(), Duration.ofMinutes(10L).toMillis())) {
                    logger.info("\u83b7\u53d6\u9501\u6210\u529f\uff1a{}", (Object)lockKey);
                    T t = supplier.get();
                    return t;
                }
            }
            try {
                throw new BusinessException(CharSequenceUtil.blankToDefault((CharSequence)acquireFailMsg, (String)("\u672a\u83b7\u53d6\u5230\u9501" + lockKey + "\uff0c\u7b49\u5f85\u8d85\u65f6")));
            }
            catch (Throwable e) {
                logger.error("\u52a0\u9501\u7684\u65b9\u6cd5\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            logger.info("\u91ca\u653e\u672c\u5730\u9501\uff1a{}", (Object)lockKey);
            try {
                lockLocal.unlock();
            }
            catch (Exception e) {
                logger.error("\u672c\u5730\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
            }
            if (lockRemote) {
                logger.info("\u91ca\u653e\u8fdc\u7a0b\u9501\uff1a{}", (Object)lockKey);
                try {
                    LockUtil.unlock(lockKey);
                }
                catch (Exception e) {
                    logger.error("\u8fdc\u7a0b\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                }
            }
        }
    }

    public static <T> T executeByLockByRedisson(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration, String acquireFailMsg) {
        Assert.hasText((String)lockKey, (String)"\u9501\u7684\u6807\u8bc6\u4e3a\u7a7a");
        if (duration == null) {
            duration = Duration.ofMinutes(10L);
        }
        Lock lockLocal = LOCAL_LOCK.computeIfAbsent(lockKey, c -> new ReentrantLock());
        RLock lockRemote = null;
        try {
            logger.info("\u5c1d\u8bd5\u83b7\u53d6\u672c\u5730\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
            if (lockLocal.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                lockRemote = LockUtil.getRedissonClient().getLock(lockKey);
                logger.info("\u5c1d\u8bd5\u83b7\u53d6\u8fdc\u7a0b\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
                if (lockRemote.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                    logger.info("\u83b7\u53d6\u9501\u6210\u529f\uff1a{}", (Object)lockKey);
                    T t = supplier.get();
                    return t;
                }
            }
            try {
                throw new BusinessException(CharSequenceUtil.blankToDefault((CharSequence)acquireFailMsg, (String)("\u672a\u83b7\u53d6\u5230\u9501" + lockKey + "\uff0c\u7b49\u5f85\u8d85\u65f6")));
            }
            catch (Throwable e) {
                logger.error("\u52a0\u9501\u7684\u65b9\u6cd5\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                if (e instanceof BusinessException) {
                    throw (BusinessException)e;
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            logger.info("\u91ca\u653e\u672c\u5730\u9501\uff1a{}", (Object)lockKey);
            try {
                lockLocal.unlock();
            }
            catch (Exception e) {
                logger.error("\u672c\u5730\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
            }
            if (lockRemote != null && lockRemote.isLocked()) {
                logger.info("\u91ca\u653e\u8fdc\u7a0b\u9501\uff1a{}", (Object)lockKey);
                try {
                    lockRemote.unlock();
                }
                catch (Exception e) {
                    logger.error("\u8fdc\u7a0b\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                }
            }
        }
    }

    public static <T> T executeForNoWait(@NotBlank String lockKey, @NotNull Supplier<T> supplier) {
        return LockUtil.executeForNoWait(lockKey, supplier, null, null);
    }

    public static <T> T executeForNoWait(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration) {
        return LockUtil.executeForNoWait(lockKey, supplier, duration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeForNoWait(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration, String failMsg) {
        T t;
        if (duration == null) {
            duration = Duration.ofMinutes(1L);
        }
        if (StrUtil.isNotBlank((CharSequence)failMsg)) {
            failMsg = "\u6709\u5728\u6267\u884c\u4e2d\u7684\u64cd\u4f5c, \u8bf7\u7a0d\u540e\u518d\u8bd5";
        }
        Boolean lockResult = redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"1", duration);
        logger.info("\u5c1d\u8bd5\u83b7\u53d6\u9501\uff1a{}, {}", (Object)lockKey, (Object)lockResult);
        if (Boolean.FALSE.equals(lockResult)) {
            throw new BusinessException(failMsg);
        }
        try {
            t = supplier.get();
        }
        catch (Throwable throwable) {
            boolean hasTransaction = TransactionSynchronizationManager.isActualTransactionActive();
            if (hasTransaction) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(lockKey){
                    final /* synthetic */ String val$lockKey;
                    {
                        this.val$lockKey = string;
                    }

                    public void afterCompletion(int status) {
                        logger.info("\u4e8b\u52a1\u7ed3\u675f\uff0c\u91ca\u653e\u9501\uff1a{}", (Object)this.val$lockKey);
                        redisTemplate.delete((Object)this.val$lockKey);
                    }
                });
            } else {
                logger.info("\u65e0\u4e8b\u52a1\uff0c\u91ca\u653e\u9501\uff1a{}", (Object)lockKey);
                redisTemplate.delete((Object)lockKey);
            }
            throw throwable;
        }
        boolean hasTransaction = TransactionSynchronizationManager.isActualTransactionActive();
        if (hasTransaction) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
        } else {
            logger.info("\u65e0\u4e8b\u52a1\uff0c\u91ca\u653e\u9501\uff1a{}", (Object)lockKey);
            redisTemplate.delete((Object)lockKey);
        }
        return t;
    }

    private static boolean tryLock(String lockKey, long waitTime, long leaseTime) {
        long end = System.currentTimeMillis() + waitTime;
        while (System.currentTimeMillis() < end) {
            Boolean success = LockUtil.getRedisTemplate().opsForValue().setIfAbsent((Object)lockKey, (Object)"1", leaseTime, TimeUnit.MILLISECONDS);
            if (Boolean.TRUE.equals(success)) {
                return true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    private static void unlock(String lockKey) {
        LockUtil.getRedisTemplate().delete((Object)lockKey);
    }

    private static RedissonClient getRedissonClient() {
        if (redissonClient == null) {
            redissonClient = SpringContextHolder.getBean(RedissonClient.class);
        }
        return redissonClient;
    }

    private static StringRedisTemplate getRedisTemplate() {
        if (redisTemplate == null) {
            redisTemplate = SpringContextHolder.getBean(StringRedisTemplate.class);
        }
        return redisTemplate;
    }
}

