/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.terms.CronTerm;
import java.util.Objects;

public abstract class AbstractCronTerm
implements CronTerm {
    private final CronBuilder cronBuilder;

    public AbstractCronTerm(CronBuilder cronBuilder) {
        this.cronBuilder = cronBuilder;
    }

    public abstract String buildExpression();

    public CronBuilder and() {
        return this.cronBuilder;
    }

    static class TwoDigitValue {
        private final int digit;
        private final int value;

        public TwoDigitValue(int digit, int value) {
            this.digit = digit;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public int getDigit() {
            return this.digit;
        }

        public String toString() {
            return this.digit + "#" + this.value;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoDigitValue that = (TwoDigitValue)o;
            return this.digit == that.digit && this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.digit, this.value);
        }
    }

    static class RateValue {
        private final Integer start;
        private final int rate;

        public RateValue(Integer start, int rate) {
            this.start = start;
            this.rate = rate;
        }

        public RateValue(int rate) {
            this.start = null;
            this.rate = rate;
        }

        public Integer getStart() {
            return this.start;
        }

        public int getRate() {
            return this.rate;
        }

        public String toString() {
            return String.valueOf(ObjUtil.defaultIfNull((Object)this.start, (Object)"*")) + "/" + this.rate;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateValue rateValue = (RateValue)o;
            return Objects.equals(this.start, rateValue.start) && this.rate == rateValue.rate;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.rate);
        }
    }

    static class RangeValue {
        private final int start;
        private final int end;

        public RangeValue(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeValue rangeValue = (RangeValue)o;
            return this.start == rangeValue.start && this.end == rangeValue.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }
}

