/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.util.encrypt.BaseEncrypt;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.util.Assert;

public class JwtUtil {
    private static final Logger logger = CloudtBootLoggerFactory.BOOT.getLogger(JwtUtil.class);

    private JwtUtil() {
    }

    public static JwtDecoder buildJwtDecoder(@NonNull RSAKey rsaKey) {
        Assert.notNull((Object)rsaKey, (String)"rsaKey\u4e3a\u7a7a");
        try {
            return NimbusJwtDecoder.withPublicKey((RSAPublicKey)rsaKey.toRSAPublicKey()).build();
        }
        catch (JOSEException e) {
            logger.error("jwtDecoder\u6784\u5efa\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static JwtEncoder buildJwtEncoder(@NonNull RSAKey rsaKey) {
        Assert.notNull((Object)rsaKey, (String)"rsaKey\u4e3a\u7a7a");
        JWKSource<SecurityContext> jwkSource = JwtUtil.generateJwkSource(rsaKey);
        return new NimbusJwtEncoder(jwkSource);
    }

    public static RSAKey loadRSAKey(@NonNull KeyStore keyStore, String alias, @NonNull String secret) {
        Assert.notNull((Object)keyStore, (String)"keyStore\u4e3a\u7a7a");
        Assert.hasText((String)alias, (String)"alias\u4e3a\u7a7a");
        Assert.hasText((String)secret, (String)"secret\u4e3a\u7a7a");
        try {
            return RSAKey.load((KeyStore)keyStore, (String)alias, (char[])secret.toCharArray());
        }
        catch (Exception e) {
            logger.error("rsaKey\u52a0\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyStore loadKeystore(@NonNull InputStream keystoreStream, String type, String password, String alias, String secret) {
        try {
            return BaseEncrypt.loadKeystore(keystoreStream, type, password, alias, secret);
        }
        catch (Exception e) {
            logger.error("keystore\u52a0\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyStore loadKeystore(@NonNull Resource keystoreResource, String type, @NonNull String password, String alias, String secret) {
        try {
            return BaseEncrypt.loadKeystore(keystoreResource, type, password, alias, secret);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7dkeystore\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u52a0\u8f7dkeystore\u5931\u8d25", e);
        }
    }

    public static JWKSource<SecurityContext> generateJwkSource(@NonNull RSAKey rsaKey) {
        JWKSet jwkSet = new JWKSet((JWK)rsaKey);
        return (jwkSelector, securityContext) -> jwkSelector.select(jwkSet);
    }

    public static Map<String, Object> decode(String jwtStr) {
        if (CharSequenceUtil.isBlank((CharSequence)jwtStr)) {
            return Collections.emptyMap();
        }
        int partSize = jwtStr.split("\\.").length;
        try {
            if (partSize == 3) {
                return SignedJWT.parse((String)jwtStr).getPayload().toJSONObject();
            }
            if (partSize == 2) {
                return PlainJWT.parse((String)jwtStr).getPayload().toJSONObject();
            }
            if (partSize == 5) {
                return EncryptedJWT.parse((String)jwtStr).getPayload().toJSONObject();
            }
        }
        catch (ParseException e) {
            logger.error("\u89e3\u5bc6jwt\u5931\u8d25\uff1a{}", (Object)jwtStr);
            throw new IllegalArgumentException("\u89e3\u5bc6jwt\u5931\u8d25\uff1a", e);
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684jwt\u683c\u5f0f");
    }
}

