/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util.cron.terms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.terms.AbstractCronTerm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class YearCronTerm
extends AbstractCronTerm {
    private Boolean every;
    private Boolean notAssign;
    private Set<Integer> specificValues;
    private AbstractCronTerm.RangeValue rangeValue;

    public YearCronTerm(CronBuilder cronBuilder) {
        super(cronBuilder);
    }

    public YearCronTerm every() {
        this.every = true;
        return this;
    }

    public YearCronTerm notAssign() {
        this.notAssign = true;
        return this;
    }

    public YearCronTerm of(Integer ... years) {
        if (years == null || years.length == 0) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(Arrays.asList(years));
        return this;
    }

    public YearCronTerm of(List<Integer> years) {
        if (years == null || years.isEmpty()) {
            return this;
        }
        if (this.specificValues == null) {
            this.specificValues = new HashSet<Integer>(60);
        }
        this.specificValues.addAll(years);
        return this;
    }

    public YearCronTerm ofRange(int start, int end) {
        this.rangeValue = new AbstractCronTerm.RangeValue(start, end);
        return this;
    }

    @Override
    public String buildExpression() {
        if (Boolean.TRUE.equals(this.every)) {
            return "*";
        }
        if (Boolean.TRUE.equals(this.notAssign)) {
            return "?";
        }
        if (CollUtil.isNotEmpty(this.specificValues)) {
            return this.specificValues.stream().peek(this::validateValue).sorted().map(String::valueOf).collect(Collectors.joining(","));
        }
        if (this.rangeValue != null) {
            this.validateValue(this.rangeValue.getStart());
            this.validateValue(this.rangeValue.getEnd());
            if (this.rangeValue.getStart() > this.rangeValue.getEnd()) {
                throw new IllegalArgumentException("\u5e74\u7684\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u622a\u6b62\u65f6\u95f4");
            }
            return this.rangeValue.getStart() + "-" + this.rangeValue.getEnd();
        }
        return "?";
    }

    private void validateValue(int value) {
        Assert.isTrue((value >= 1 && value <= 9999 ? 1 : 0) != 0, (String)"\u5e74\u7684\u503c\u8303\u56f41-9999", (Object[])new Object[0]);
    }
}

