package com.elitescloud.boot.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 发送验证码参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/16
 */
@ApiModel(description = "发送验证码参数")
@Data
public class SysSendVerifyCodeVO implements Serializable {
    private static final long serialVersionUID = -6401565900569032799L;

    @ApiModelProperty(value = "账号（手机号或邮箱）", position = 1, required = true)
    @NotBlank(message = "账号不能为空")
    private String account;

    @ApiModelProperty(value = "账号类型（mobile-手机号，email-邮箱），默认是mobile", position = 2)
    private String accountType;

    @ApiModelProperty(value = "验证码有效期（秒为单位，默认60，最小30）", position = 3)
    private Long period;
}
