package com.elitescloud.cloudt.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户操作终端.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/28
 */
public enum Terminal {

    BACKEND("管理端"),
    APP("APP"),
    APPLET("小程序"),
    ;

    private final String description;

    Terminal(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, Terminal> terminalsMap = Arrays.stream(Terminal.values())
            .collect(Collectors.toMap(Terminal::name, t -> t, (t1, t2) -> t1));

    public static Terminal parse(String value) {
        if (value == null) {
            return null;
        }
        return terminalsMap.get(value);
    }
}
