package com.elitescloud.cloudt.common.annotation;

import java.lang.annotation.*;

/**
 * udc字段
 *
 * @author Michael Li
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysCode {
    /**
     * 领域码（应用编码）
     * <p>
     * 默认取当前应用编码
     *
     * @return 领域
     */
    String sys() default "";

    /**
     * UDC编码
     *
     * @return UDC编码
     */
    String mod();

    /**
     * 翻译后赋值的字段
     *
     * 默认是udc值字段 + Name，如 <pre>{@code
     *
     *     @SysCode(mod = "employeeType")
     *     private String type;
     *
     *     private String typeName;
     * }</pre>
     *
     * @return 字段名称
     */
    String nameField() default "";
}
