package com.elitescloud.cloudt.common.annotation.translate;

import java.lang.annotation.*;

/**
 * 用户姓名翻译.
 * <p>
 * 根据用户ID翻译用户名称，示例：
 * <pre>
 *     {@code
 *
 *          private Long userId;
 *
 *          @SysUserName(userIdField = "userId")
 *          private String userName;
 *     }
 * </pre>
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/10
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SysUserName {

    /**
     * 用户ID字段
     *
     * @return 字段名称
     */
    String userIdField();

    /**
     * 是否显示为登录号
     * <p>
     * true：显示登录号，false：姓名
     *
     * @return 是否显示为登录号
     */
    boolean showUsername() default false;
}
