/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.exception;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ErrorDetail;
import com.elitescloud.cloudt.common.base.ErrorDisplayType;
import com.elitescloud.cloudt.common.base.ErrorSource;
import java.util.function.Supplier;
import org.apache.skywalking.apm.toolkit.trace.IgnoredException;

@IgnoredException
public class BusinessException
extends RuntimeException
implements Supplier<BusinessException> {
    private static final long serialVersionUID = -2205002357611194846L;
    private ApiCode apiCode;
    private Integer code;
    private ErrorSource source;
    private ErrorDisplayType displayType;
    private ErrorDetail detail;

    public static BusinessException instance() {
        return new BusinessException();
    }

    public BusinessException() {
        this.apiCode = ApiCode.BUSINESS_EXCEPTION;
        this.code = null;
        this.source = ErrorSource.B;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(ErrorSource source, String message, ErrorDisplayType displayType, ErrorDetail detail) {
        super(message);
        this.apiCode = ApiCode.BUSINESS_EXCEPTION;
        this.code = null;
        this.source = source;
        this.displayType = displayType;
        this.detail = detail;
    }

    public BusinessException(String message, Throwable cause, ApiCode apiCode, Integer code, ErrorSource source, ErrorDisplayType displayType, ErrorDetail detail) {
        super(message, cause);
        this.apiCode = apiCode;
        this.code = code;
        this.source = source;
        this.displayType = displayType;
        this.detail = detail;
    }

    public BusinessException(String message) {
        super(message);
        this.apiCode = ApiCode.BUSINESS_EXCEPTION;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(ApiCode apiCode, String message) {
        super(message);
        this.apiCode = apiCode;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(ApiCode apiCode, String message, Throwable throwable) {
        super(message, throwable);
        this.apiCode = apiCode;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(Integer code, String message) {
        super(message);
        this.apiCode = null;
        this.code = code;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(Integer code, String message, Throwable throwable) {
        super(message, throwable);
        this.apiCode = null;
        this.code = code;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
        this.apiCode = null;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(Throwable cause) {
        super(cause);
        this.apiCode = null;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    public BusinessException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.apiCode = null;
        this.code = null;
        this.source = ErrorSource.D;
        this.displayType = ErrorDisplayType.REMINDER;
        this.detail = null;
    }

    @Override
    public BusinessException get() {
        return this;
    }

    public ApiCode getApiCode() {
        return this.apiCode;
    }

    public ErrorSource getSource() {
        return this.source;
    }

    public ErrorDisplayType getDisplayType() {
        return this.displayType;
    }

    public ErrorDetail getDetail() {
        return this.detail;
    }

    public Integer getCode() {
        if (this.code == null && this.apiCode != null) {
            return this.apiCode.getCode();
        }
        return this.code;
    }

    public BusinessException setApiCode(ApiCode apiCode) {
        this.apiCode = apiCode;
        return this;
    }

    public BusinessException setCode(Integer code) {
        this.code = code;
        return this;
    }

    public BusinessException setSource(ErrorSource source) {
        this.source = source;
        return this;
    }

    public BusinessException setDisplayType(ErrorDisplayType displayType) {
        this.displayType = displayType;
        return this;
    }

    public BusinessException setDetail(ErrorDetail detail) {
        this.detail = detail;
        return this;
    }
}

