/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.common;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CloudtOptional<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 7910368329628507484L;
    private T value;

    public CloudtOptional(T value) {
        this.value = value;
    }

    public CloudtOptional() {
    }

    public static <T extends Serializable> CloudtOptional<T> of(T value) {
        return new CloudtOptional<T>(value);
    }

    public static <T extends Serializable> CloudtOptional<T> empty() {
        return new CloudtOptional<T>();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public T orElse(T other) {
        if (this.value == null) {
            return other;
        }
        return this.value;
    }

    public T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public T get() {
        return this.value;
    }
}

