package com.elitesland.cbpl.fin.domain;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/19
 */
@Data
public class PaymentNoticeDSaveDTO implements Serializable {

    @ApiModelProperty("付款通知单ID")
    private Long masId;

    @ApiModelProperty("收费项目")
    private String chargeItems;

    @ApiModelProperty("收费项目名称")
    private String chargeItemsName;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否参与开票")
    @SysCode(sys = "yst-fin",mod = "IS_BILLING")
    private String isToBilling;

}
