package com.elitesland.cbpl.fin.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款记录保存参数")
public class PaymentRecordsSaveVO implements Serializable {
    private static final long serialVersionUID = 2617718744779453725L;

    @ApiModelProperty(" 付款通知单ID")
    @NotNull(message = "付款通知单ID不能为空")
    private Long noticeId;

    @ApiModelProperty(name = "付款日期")
    @NotNull(message = "付款日期不能为空")
    private LocalDate paymentDate;

    @ApiModelProperty(name = "支付凭证编码")
    private String voucherFileCode;

    /**
     * 加盟商ID
     */
    @ApiModelProperty("加盟商ID")
    private Long franchiseeId;

    /**
     * 加盟商编码
     */
    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String invBankNo;
    /**
     * 银行账号
     */
    @ApiModelProperty("银行账号")
    private String bankAccount;
    /**
     * 收费项目
     */
    @ApiModelProperty("收费项目")
    private String chargeItems;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("实收金额")
    private BigDecimal realRecAmt;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    private LocalDate noticeDate;

    /**
     * 通知内容
     */
    @ApiModelProperty("通知内容")
    private String noticeContent;

    @ApiModelProperty("联行号")
    private String uniBankNo;

    @ApiModelProperty("付款单状态")
    private String paymentStatus;

    @ApiModelProperty("门店code")
    private String shopCode;
    @ApiModelProperty("来源单据类型")
    private String sourceDocType;
    @ApiModelProperty("来源单据ID")
    private Long sourceDocId;
    @ApiModelProperty("来源单号")
    private String sourceDocNo;
    @ApiModelProperty("关联收款单号")
    private String associateNumber;
    @ApiModelProperty("付款银行")
    private String payBank;
    @ApiModelProperty("付款账户")
    private String payAccount;
    @ApiModelProperty("付款类型")
    private String payType;
    @ApiModelProperty("付款记录明细保存参数")
    private List<PaymentRecordsDSaveVO> paymentRecordsDList;
}
