package com.elitesland.cbpl.fin.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/21
 */
@Data
public class PaymentVoucherRespDTO implements Serializable {

    @ApiModelProperty("支付凭证表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    /**
     * 付款账户
     */
    @ApiModelProperty("付款账户")
    private String paymentAccount;
    /**
     * 付款账号
     */
    @ApiModelProperty("付款账号")
    private String paymentAccountNumber;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;
    /**
     * 支付凭证编码
     */
    @ApiModelProperty("支付凭证编码")
    private String voucherFileCode;

    @ApiModelProperty("联行号")
    private String uniBankNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("备注")
    private String remark;

}
