package com.elitesland.cbpl.fin.invoice.service;

import com.elitesland.cbpl.fin.invoice.domain.*;
import com.elitesland.cbpl.fin.invoice.vo.InvoiceApplyRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.resp.InvoiceRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/19
 */
@Unicom(domain = InvokeDomain.FINANCE, path = InvoiceApplyService.PATH)
public interface InvoiceApplyService {

    String PATH = "/rpc/invoice";

    /**
     * 根据业务单据 - 提交开票申请
     *
     * @param param 开票参数
     * @return 开票申请单
     */
    @PostMapping("/apply/create")
    InvoiceApplyRpcDTO create(@RequestBody InvoiceApplySaveParam param);

    /**
     * 根据业务单据 - 保存发票信息
     *
     * @param param 发票参数
     */
    @PostMapping("/apply/invoice/save")
    void saveInvoice(@RequestBody List<InvoiceSaveParam> param);

    /**
     * 根据单据编码 - 获取单据ID
     *
     * @param applyNo 单据编码
     * @return 单据ID
     */
    @GetMapping("/apply/getId")
    InvoiceApplyRpcDTO queryIdByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 根据来源单据ID - 获取申请单据ID
     *
     * @param param 查询条件
     * @return 单据列表
     */
    @PostMapping("/apply/query")
    List<InvoiceApplyRpcDTO> queryIdBySource(@RequestBody InvoiceQueryParam param);

    /**
     * 更新票易通上传结果
     *
     * @param xforceResult 结果状态
     */
    @PostMapping("/apply/xforce/upload")
    void updateXforceResult(@RequestBody XforceResult xforceResult);

    /**
     * 根据加盟商code查询发票抬头
     * @return
     */
    @PostMapping("/apply/xforce/invQuery")
    List<InvoiceRpcDTO> invQueryRpc(@RequestBody List<ApplyInvoiceRpcParam> applyInvoiceParam);
}
