package com.elitesland.cbpl.fin.service;

import com.elitesland.cbpl.fin.domain.ArOrderResp;
import com.elitesland.cbpl.fin.domain.ReportResp;
import com.elitesland.cbpl.mdm.Application;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;

import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

@Unicom(domain = InvokeDomain.FINANCE, path = BiReportAndArOrderSaveService.PATH)
public interface BiReportAndArOrderSaveService {

    String PATH = "/rpc/report";

    /**
     * 保存bi两张报表接口 返回报表信息
     */
    @PostMapping("/saveReport")
    List<String> saveReport(@RequestBody ReportResp resp);

    /**
     * 保存应收单信息 拿着报表信息查询合同信息
     */
    @PostMapping("/saveArOrder")
    ArOrderResp saveArOrder(@RequestBody Map<String, Object> list);
}
