package com.elitesland.cbpl.fin.invoice.service;

import com.elitesland.cbpl.fin.invoice.domain.InvoiceApplySaveParam;
import com.elitesland.cbpl.fin.invoice.domain.InvoiceSaveParam;
import com.elitesland.cbpl.fin.invoice.domain.XforceResult;
import com.elitesland.cbpl.fin.invoice.vo.InvoiceApplyRpcDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/19
 */
@Unicom(domain = InvokeDomain.FINANCE, path = InvoiceApplyService.PATH)
public interface InvoiceApplyService {

    String PATH = "/rpc/invoice";

    /**
     * 根据业务单据 - 提交开票申请
     *
     * @param param 开票参数
     * @return 开票申请单
     */
    @PostMapping("/apply/create")
    InvoiceApplyRpcDTO create(@RequestBody InvoiceApplySaveParam param);

    /**
     * 根据业务单据 - 保存发票信息
     *
     * @param param 发票参数
     */
    @PostMapping("/apply/invoice/save")
    void saveInvoice(@RequestBody List<InvoiceSaveParam> param);

    /**
     * 根据单据编码 - 获取单据ID
     *
     * @param applyNo 单据编码
     * @return 单据ID
     */
    @GetMapping("/apply/getId")
    InvoiceApplyRpcDTO queryIdByApplyNo(@RequestParam("applyNo") String applyNo);

    /**
     * 更新票易通上传结果
     *
     * @param xforceResult 结果状态
     */
    @PostMapping("/apply/xforce/upload")
    void updateXforceResult(@RequestBody XforceResult xforceResult);
}
