package com.elitesland.cbpl.mdm.rpc.resp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author xiaow
 * @version 1.0
 * @description: TODO
 * @date 2023/10/26 16:07
 */
@Data
public class TimsItmItemCateSimpleTreeDTO{
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("pid")
    private Long pid;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 子节点
     */
    @ApiModelProperty(value = "子节点")
    private List<TimsItmItemCateSimpleTreeDTO> treeNodes;

    /**
     * 商品品类编码
     */
    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    /**
     * 商品品类名称
     */
    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;
}
