package com.elitesland.cbpl.mdm.rpc.resp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by lance on 2023/8/7.
 */
@Data
@ApiModel(description = "组织树明细反参")
public class TsOrgTreeDRpcDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树节点ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树ID")
    private Long buTreeId;


    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "关联表数据ID")
    private Long relatedId;

    /**
     * 关联表数据Code
     */
    @ApiModelProperty(value = "关联表数据Code")
    private String relatedCode;

    @ApiModelProperty(value = "关联表数据名称")
    private String relatedName;

    @ApiModelProperty(value = "关联表数据类型")
    private String relatedType;
    private String relatedTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty(value = "组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "yst-supp", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    @ApiModelProperty("节点路径")
    private String codePath;

    /**
     * 商品品类下级
     */
    @ApiModelProperty(value = "商品品类下级")
    private List<TsOrgTreeDRpcDTO> treeNodes;
}
