package com.elitesland.cbpl.mdm.rpc;

import com.elitesland.cbpl.mdm.rpc.param.resp.OrgOuDTO;
import com.elitesland.cbpl.mdm.rpc.param.save.OuBankApiRespVo;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + OrgOuService.URI)
public interface OrgOuService {
    String URI = com.elitesland.cbpl.mdm.Application.URI_PREFIX + "/org";

    @GetMapping("/findBankInfo/{ouType}")
    OuBankApiRespVo findOuBankInfo(@PathVariable(value = "ouType") String ouType);

    @GetMapping("/findOuCode/{ouCode}")
    List<OrgOuDTO> findOuCode(@PathVariable(value = "ouCode") String ouCode);

    @GetMapping("/findOuCodeBankInfo/{ouCode}")
    OuBankApiRespVo findOuCodeBankInfo(@PathVariable(value = "ouCode") String ouType);
}
