package com.elitesland.cbpl.mdm.rpc;

import com.elitesland.cbpl.mdm.rpc.param.resp.TsItmItemRpcDTO;
import com.elitesland.cbpl.mdm.rpc.param.save.ItmItemParam;
import com.elitesland.cbpl.mdm.rpc.resp.ItmItemResp;
import com.elitesland.cbpl.mdm.rpc.resp.TimsItmItemCateSimpleTreeDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.support.provider.item.dto.ItmItemRpcDTO;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Unicom(domain = InvokeDomain.SUPPORT, path = Application.PATH + TimsItemRpcService.PATH)
public interface TimsItemRpcService {
    String PATH = "/rpc/item";

    @PostMapping("/findBatchItemByParam")
    List<TsItmItemRpcDTO> findBatchItemByParam(@RequestBody ItmItemRpcDtoParam param);
    @PostMapping("/queryItmItemList")
    List<ItmItemResp> queryItmItemList( @RequestBody ItmItemParam param);
    @PostMapping("/queryItemCate")
    List<TimsItmItemCateSimpleTreeDTO> findItemCatePath(@RequestParam("itemCatCode") String itemCateCode);


    @PostMapping("/queryItmItemByRedis")
    List<ItmItemRpcDTO> queryItmItemByRedis(@RequestBody ItmItemParam param);
}
