package com.elitesland.cbpl.mdm.rpc.param.resp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/12
 */
@Data
public class TsOrgAddrBankAccRpcDTO implements Serializable {

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty(value = "账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_BANKACC_TYPE")
    private String accType;
    @ApiModelProperty(value = "账号类型名称")
    private String accTypeName;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty(value = "是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 银行ID
     */
    @ApiModelProperty(value = "银行ID")
    private Long bankId;

    /**
     * 银行编号
     */
    @ApiModelProperty(value = "银行编号")
    private String bankCode;

    /**
     * 银行名称
     */
    @ApiModelProperty(value = "银行名称")
    private String bankName;

    /**
     * 网点名称
     */
    @ApiModelProperty(value = "网点名称")
    private String branchName;

    /**
     * 开户行账号
     */
    @ApiModelProperty(value = "开户行账号")
    private String bankAcc;

    /**
     * 开户人姓名
     */
    @ApiModelProperty(value = "开户人姓名")
    private String holderName;

    /**
     * 币种
     */
    @ApiModelProperty(value = "币种")
    private String currCode;

    /**
     * 币种名称
     */
    @ApiModelProperty(value = "币种名称")
    private String currName;

    /**
     * 收付款方式
     */
    @ApiModelProperty(value = "收付款方式 [UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethod;

    /**
     * 收付款方式
     */
    @ApiModelProperty(value = "收付款方式 [UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethodName;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    @SysCode(sys = "yst-supp", mod = "ADDR_TYPE")
    private String dataSource;
    private String dataSourceName;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

}
