package com.elitescloud.cloudt.tims.sso;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * tims单点登录配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@ConfigurationProperties(prefix = TimsSsoProperties.CONFIG_PREFIX)
public class TimsSsoProperties {
    public static final String CONFIG_PREFIX = "elitesland.tims.sso";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 服务端地址
     * <p>
     * 由SSO提供
     */
    private String serverAddr;

    /**
     * 应用ID
     * <p>
     * 由SSO提供
     */
    private String appId = "1002";

    /**
     * 品牌编号
     * <p>
     * 由SSO提供
     */
    private String brandCode = "1001";

    /**
     * 是否强制进行SSO验证
     * <p>
     * 当sysUserDo.casEnabled != false时是否必须sso
     */
    private Boolean forced = true;

    /**
     * token有效期
     */
    private Duration tokenTtl = Duration.ofMinutes(60);

    /**
     * token续期时间间隔
     */
    private Duration renewRate = Duration.ofMinutes(20);

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getServerAddr() {
        return serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public Boolean getForced() {
        return forced;
    }

    public void setForced(Boolean forced) {
        this.forced = forced;
    }

    public Duration getTokenTtl() {
        return tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public Duration getRenewRate() {
        return renewRate;
    }

    public void setRenewRate(Duration renewRate) {
        this.renewRate = renewRate;
    }
}
