package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Slf4j
@RestController
@Api(value = "平台菜单", tags = {"平台菜单管理"})
@RequestMapping("/sys/platform/menus")
public class SysPlatformMenusController {

   private final SysPlatformMenusService sysPlatformMenusService;

    public SysPlatformMenusController(SysPlatformMenusService sysPlatformMenusService) {
        this.sysPlatformMenusService = sysPlatformMenusService;
    }


    @PostMapping("/addMenus")
    @ApiOperation(value = "添加菜单", notes = "平台菜单管理")
    public ApiResult<Long> addMenus(@RequestBody @Valid AddMenusParam addMenusParam) {
        return sysPlatformMenusService.addMenus(addMenusParam);
    }
    @PostMapping("/addButton")
    @ApiOperation(value = "添加按钮", notes = "平台菜单管理")
    public ApiResult<Long> addButton(@RequestBody @Valid AddButtonParam addButtonParam) {
        return sysPlatformMenusService.addButton(addButtonParam);
    }
    @PostMapping("/addMenusGroup")
    @ApiOperation(value = "添加菜单分组", notes = "平台菜单管理")
    public ApiResult<Long> addMenusGroup(@RequestBody @Valid AddMenusParam addMenusParam) {
        return sysPlatformMenusService.addMenusGroup(addMenusParam);
    }
    @PutMapping("/updateMenusGroup/{id}")
    @ApiOperation(value = "更新菜单分组信息", notes = "平台菜单管理")
    public ApiResult<Boolean> updateMenusGroup(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return sysPlatformMenusService.updateMenusGroup(id, updateMenusParam);
    }
    @PutMapping("/updateMenus/{id}")
    @ApiOperation(value = "更新菜单信息", notes = "平台菜单管理")
    public ApiResult<Boolean> updateMenus(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return sysPlatformMenusService.updateMenus(id, updateMenusParam);
    }
    @PutMapping("/updateButton/{id}")
    @ApiOperation(value = "更新按钮信息", notes = "平台菜单管理")
    public ApiResult<Boolean> updateButton(@PathVariable Long id, @RequestBody UpdateButtonParam updateMenusParam) {
        return sysPlatformMenusService.updateButton(id, updateMenusParam);
    }

    @ApiOperation(value = "物理删除菜单", notes = "平台菜单管理")
    @PutMapping("/deleteFlagMenus/{id}")
    public ApiResult<Boolean> deleteFlagMenus(@PathVariable Long id) {
        // return sysPlatformMenusService.deleteFlagMenus(id);
        return sysPlatformMenusService.deleteMenus(id);
    }

//    @ApiOperation(value = "删除菜单", notes = "平台菜单管理")
//    @DeleteMapping("/delete/{id}")
//    public ApiResult<Boolean> deleteMenus(@PathVariable Long id) {
//        return sysPlatformMenusService.deleteMenus(id);
//    }

    @PutMapping("/updateMenusState/{id}/{state}")
    @ApiOperation(value = "更新菜单是否启用状态", notes = "平台菜单管理")
    public ApiResult<Boolean> updateMenusState(@PathVariable Long id, @PathVariable Boolean state) {
        return sysPlatformMenusService.updateMenusState(id, state);
    }


    @GetMapping("/getMenus/{id}")
    @ApiOperation(value = "id查询菜单", notes = "平台菜单管理")
    public ApiResult<SysPlatformMenusVO> getMenus(@PathVariable Long id) {
        return sysPlatformMenusService.getMenus(id);
    }

    @GetMapping("/getSysAppMenus")
    @ApiOperation(value = "返回系统应用和系统菜单数据-状态都是启用", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getSysAppMenus() {

        return sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }
    @GetMapping("/getBusAppMenus")
    @ApiOperation(value = "返回业务应用和业务菜单数据-状态都是启用", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getBusAppMenus() {
        return sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }
    @GetMapping("/getSysAppMenusAll")
    @ApiOperation(value = "返回系统应用和系统菜单数据-状态启用和非启用", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getSysAppMenusAll() {

        return sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }
    @GetMapping("/getBusAppMenusAll")
    @ApiOperation(value = "返回业务应用和业务菜单数据-状态启用和非启用", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getBusAppMenusAll() {
        return sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }
    /**
     * 返回全部应用和菜单数据
     **/
    @GetMapping("/getAllAppMenus")
    @ApiOperation(value = "返回全部应用和菜单-状态启用和非启用", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        return sysPlatformMenusService.getAllAppMenus();
    }


    @PostMapping("/queryMenus")
    @ApiOperation(value = "查询菜单", notes = "平台菜单管理")
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(@RequestBody @Valid QueryMenusParam queryMenusParam) {
         return sysPlatformMenusService.queryMenus(queryMenusParam);
    }

    @GetMapping("/enum/getMenusTypeEnum")
    @ApiOperation(value = "菜单类型枚举", notes = "平台菜单管理")
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
        return sysPlatformMenusService.getMenusTypeEnum();
    }



}
