package com.elitescloud.cloudt.platform.model.constant;

import io.swagger.annotations.ApiModelProperty;


/***
 * 设置参数
 * */
public enum SysPlatformSettingParameterEnum {

    /**用户安全设置分组**/
    USER_DEFAUL_PASSWORD(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.USER_SECURITY_GROUP,
            "USER_DEFAUL_PASSWORD", "用户默认密码",
            "用户默认密码设置", "123456", 1,
            "", ""
    ),
    UPDATE_PASSWORD_SMS(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.USER_SECURITY_GROUP,
            "UPDATE_PASSWORD_SMS", "修改密码发送短信",
            "修改密码发送短信", "false", 2,
            "", ""
    ),
    UPDATE_PASSWORD_MAIL(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.USER_SECURITY_GROUP,
            "UPDATE_PASSWORD_SMS", "修改密码发送邮箱",
            "修改密码发送邮箱", "false", 3,
            "", ""
    ),

    /**平台设置分组**/
    ACCOUNT_LOGIN_PERMISSION(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.PLATFORM_SETTING_GROUP,
            "ACCOUNT_LOGIN_PERMISSION",
            "账号登录允许项",
            "账号登录允许项设置", "all", 2
            , "", ""
    ),

    PASSWORD_ERR_LOCK(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.PLATFORM_SETTING_GROUP,
            "PASSWORD_ERR_LOCK",
            "密码错误次数锁定",
            "密码错误次数锁定设置", "3", 2
            , "", ""
    ),

    UPLOAD_FILE_SIZE(
            SysPlatformSettingTypeEnum.SETTING_TYPE_SYS,
            SysPlatformSettingGroupEnum.PLATFORM_SETTING_GROUP,
            "UPLOAD_FILE_SIZE",
            "文件上传大小/MB",
            "文件上传大小设置", "200", 3
            , "", ""
    ),

    ;


    @ApiModelProperty(value = "设置的编号")
    private String settingNo;
    @ApiModelProperty(value = "设置名称")
    private String settingName;
    @ApiModelProperty(value = "设置类型 系统,业务")
    private SysPlatformSettingTypeEnum settingType;
    @ApiModelProperty(value = "设置类型2")
    private String settingType2;
    @ApiModelProperty(value = "应用编码")
    private String appCode;
    @ApiModelProperty(value = "设置分组")
    private SysPlatformSettingGroupEnum settingGroup;
    @ApiModelProperty(value = "设置描述")
    private String settingDesc;
    //    @ApiModelProperty(value = "设置值")
//    private String settingVal;
    @ApiModelProperty(value = "默认值")
    private String defaultValue;
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    SysPlatformSettingParameterEnum(
            SysPlatformSettingTypeEnum settingType,
            SysPlatformSettingGroupEnum settingGroup,
            String settingNo, String settingName,
            String settingDesc, String defaultValue, int sortNo,
            String settingType2,
            String appCode
    ) {
        this.settingNo = settingNo;
        this.sortNo = sortNo;
        this.settingName = settingName;
        this.settingType = settingType;
        this.settingDesc = settingDesc;
        this.appCode = appCode;
        this.settingType2 = settingType2;
        this.settingGroup = settingGroup;
        this.defaultValue = defaultValue;
    }

}
