package com.elitescloud.cloudt.platform.model.entity;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * 管理员菜单
 */
@Entity
@Table(name = "sys_platform_admin_menus", indexes = {
        @Index(name = "idx_admin_menu_type", columnList = "adminType")
})
@org.hibernate.annotations.Table(appliesTo = "sys_platform_admin_menus", comment = "管理员菜单")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = "sys_platform_admin_menus", description = "管理员菜单")
public class SysPlatformAdminMenusDO extends BaseModel implements Serializable {
    @ApiModelProperty("管理员类型")
    @Comment("管理员类型")
    @Column
    String adminType;

    @ApiModelProperty("菜单编码")
    @Comment("菜单编码")
    @Column
    String menusCode;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformAdminMenusDO that = (SysPlatformAdminMenusDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
