package com.elitescloud.cloudt.platform.model.entity;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <pre>发号器规则明细</pre>
 *
 * @author Michael Li
 * 2020-10-10
 **/

@Entity
@Table(name = "sys_platform_number_ruledtl", indexes = {
    @Index(name = "idx_sysplatform_number_ruledtl_rule_id", columnList = "ruleId")
})
@org.hibernate.annotations.Table(appliesTo = "sys_platform_number_ruledtl", comment = "发号器规则明细")
@Data
@Accessors(chain = true)
@ApiModel(value = "发号器规则明细", description = "发号器规则明细")
public class SysPlatformNumberRuleDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 2847171578260093086L;

    @ApiModelProperty(value = "应用编号")
    @Comment("应用编号")
    @Column(nullable = false)
    String appCode;

    @ApiModelProperty(value = "发号器规则ID")
    @Comment("发号器规则ID")
    @Column()
    Long ruleId;
    
    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column()
    Integer seq;
    
    @ApiModelProperty(value = "取号类型：sys:numbertype, fs:固定字符串；dp：格式化日期；nn：自增序号；rv: 运行时传值，由调用者以数组方式提供")
    @Comment("取号类型：sys:numbertype")
    @Column()
    String numberType;  
    
    @ApiModelProperty(value = "取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码、运行时传值，由调用者以数组方式提供")
    @Comment("取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码")
    @Column()
    String numberPattern;

    @ApiModelProperty(value = "自增序号宽度，默认左补零")
    @Comment("自增序号宽度，默认左补零")
    @Column()
    Integer nnLen;
    
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysPlatformNumberRuleDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysPlatformNumberRuleDtlDO entity = (SysPlatformNumberRuleDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
