package com.elitescloud.cloudt.platform.model.params.api;

import com.elitescloud.cloudt.platform.model.constant.PlatformRequestTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.23
 **/
@Data
public class AddApiPermissionParam implements Serializable {

    @ApiModelProperty("菜单编码")
    @NotBlank(message = "菜单编码不能为空")
    String menusCode;

    @ApiModelProperty("权限路径")
    @NotBlank(message = "权限路径不能为空")
    String permissonPath;

    @ApiModelProperty("权限名称")
    @NotBlank(message = "权限名称不能为空")
    String permissonName;

    @ApiModelProperty("权限编码")
    @NotBlank(message = "权限编码不能为空")
    String permissonCode;

    @ApiModelProperty("请求类型")
    @NotNull(message = "请求类型不能为空")
    PlatformRequestTypeEnum requestType;

    @ApiModelProperty("描述")
    String permissonDescribe;

}
