package com.elitescloud.cloudt.platform.model.params.udc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.23
 **/
@Data
public class AddUdcParam implements Serializable {
    private static final long serialVersionUID = 2114523784477354177L;

    @ApiModelProperty("应用编码")
    @NotBlank(message = "应用编码不能为空")
    String appCode;

    @ApiModelProperty("编码")
    @NotBlank
    String udcCode;

    @ApiModelProperty("名称")
    @NotBlank
    String udcName;

    @ApiModelProperty("允许编辑")
    Boolean allowUpdate;

    @ApiModelProperty("允许新增值")
    Boolean allowAddValue;

    @ApiModelProperty("描述")
    String udcDescribe;

//    @ApiModelProperty("UDC值")
//    List<AddUdcValueParam> sysPlatformUdcValueVOList;
    @ApiModelProperty("上级UDC编码")
    private String parentUdcCode;
}
