package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.platform.convert.SysPlatformNextNumberConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformNextNumberDO;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumPageQueryParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumSaveParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformSeqNumUpdateParam;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumPageRespVO;
import com.elitescloud.cloudt.platform.model.vo.sequence.SysPlatformSeqNumRespVO;
import com.elitescloud.cloudt.platform.service.SysPlatformSeqNumMngService;
import com.elitescloud.cloudt.platform.service.repo.number.SysPlatformNextNumberRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.29
 **/
@Service
@RequiredArgsConstructor
public class SysPlatformSeqNumMngServiceImpl implements SysPlatformSeqNumMngService {
    private final SysPlatformNextNumberRepo sysPlatformNextNumberRepo;
//    private final SysPlatformNextNumberRepoProc sysPlatformNextNumberRepoProc;

    @Override
    public ApiResult<Long> update(Long id, SysPlatformSeqNumUpdateParam saveVO) {
        sysPlatformNextNumberRepo.findById(id).ifPresentOrElse(sysPlatformNextNumberDO -> {
                    sysPlatformNextNumberDO.setName(saveVO.getName());
                    sysPlatformNextNumberDO.setStep(saveVO.getStep());
                    sysPlatformNextNumberDO.setNextNumber(saveVO.getNextNumber());
                    sysPlatformNextNumberDO.setNnPeriod(saveVO.getNnPeriod());
                    sysPlatformNextNumberDO.setEnabled(saveVO.getEnabled());
                    sysPlatformNextNumberRepo.save(sysPlatformNextNumberDO);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<Long> save(SysPlatformSeqNumSaveParam saveVO) {
        var qdo = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;
        long countDo = sysPlatformNextNumberRepo.count(qdo.code.eq(saveVO.getCode()));
        if (countDo != 0) {
            return ApiResult.fail("编码不能重复");
        } else {
            var sdo = SysPlatformNextNumberConvert.INSTANCE.voToDO(saveVO);
            sysPlatformNextNumberRepo.save(sdo);
            return ApiResult.ok(sdo.getId());
        }
    }

    @Override
    public ApiResult<SysPlatformSeqNumRespVO> get(Long id) {
        var sdoOp = sysPlatformNextNumberRepo.findById(id);
        if (sdoOp.isPresent()) {
            var svo = SysPlatformNextNumberConvert.INSTANCE.doToVO(sdoOp.get());
            return ApiResult.ok(svo);
        }
        return ApiResult.fail("id不存在");
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        sysPlatformNextNumberRepo.deleteById(id);
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<Long> switchEnabled(Long id, Boolean enabled) {
        sysPlatformNextNumberRepo.findById(id).ifPresentOrElse(sysPlatformNextNumberDO -> {
                    sysPlatformNextNumberDO.setEnabled(enabled);
                    sysPlatformNextNumberRepo.save(sysPlatformNextNumberDO);
                },
                () -> {
                    throw new BusinessException("id不存在");
                });
        return ApiResult.ok(id);
    }

    @Override
    public ApiResult<PagingVO<SysPlatformSeqNumPageRespVO>> page(SysPlatformSeqNumPageQueryParam param) {
        var qdo = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;
        Predicate predicate = Expressions.booleanTemplate("1=1");

        predicate = org.apache.commons.lang3.StringUtils.isBlank(param.getAppCode()) ? predicate :
                ExpressionUtils.and(predicate, qdo.appCode.eq(param.getAppCode()));

        predicate = org.apache.commons.lang3.StringUtils.isBlank(param.getCode()) ? predicate :
                ExpressionUtils.and(predicate, qdo.code.eq(param.getCode()));

         var page = sysPlatformNextNumberRepo.findAll(predicate, param.getPageRequest());


        var pagingVo = PagingVO.<SysPlatformSeqNumPageRespVO>builder()
                .total(page.getTotalElements())
                .setRecords(page.get().map(SysPlatformNextNumberConvert.INSTANCE::doPageToVO)
                        .collect(Collectors.toList()));

        return ApiResult.ok(pagingVo);
    }
}
